/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.pi.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAvailableResourceDimensionsResponse extends PiResponse implements
        ToCopyableBuilder<ListAvailableResourceDimensionsResponse.Builder, ListAvailableResourceDimensionsResponse> {
    private static final SdkField<List<MetricDimensionGroups>> METRIC_DIMENSIONS_FIELD = SdkField
            .<List<MetricDimensionGroups>> builder(MarshallingType.LIST)
            .memberName("MetricDimensions")
            .getter(getter(ListAvailableResourceDimensionsResponse::metricDimensions))
            .setter(setter(Builder::metricDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDimensions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricDimensionGroups> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricDimensionGroups::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAvailableResourceDimensionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DIMENSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MetricDimensionGroups> metricDimensions;

    private final String nextToken;

    private ListAvailableResourceDimensionsResponse(BuilderImpl builder) {
        super(builder);
        this.metricDimensions = builder.metricDimensions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricDimensions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricDimensions() {
        return metricDimensions != null && !(metricDimensions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dimension information returned for requested metric types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricDimensions} method.
     * </p>
     * 
     * @return The dimension information returned for requested metric types.
     */
    public final List<MetricDimensionGroups> metricDimensions() {
        return metricDimensions;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricDimensions() ? metricDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAvailableResourceDimensionsResponse)) {
            return false;
        }
        ListAvailableResourceDimensionsResponse other = (ListAvailableResourceDimensionsResponse) obj;
        return hasMetricDimensions() == other.hasMetricDimensions()
                && Objects.equals(metricDimensions(), other.metricDimensions()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAvailableResourceDimensionsResponse")
                .add("MetricDimensions", hasMetricDimensions() ? metricDimensions() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricDimensions":
            return Optional.ofNullable(clazz.cast(metricDimensions()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAvailableResourceDimensionsResponse, T> g) {
        return obj -> g.apply((ListAvailableResourceDimensionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PiResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAvailableResourceDimensionsResponse> {
        /**
         * <p>
         * The dimension information returned for requested metric types.
         * </p>
         * 
         * @param metricDimensions
         *        The dimension information returned for requested metric types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDimensions(Collection<MetricDimensionGroups> metricDimensions);

        /**
         * <p>
         * The dimension information returned for requested metric types.
         * </p>
         * 
         * @param metricDimensions
         *        The dimension information returned for requested metric types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDimensions(MetricDimensionGroups... metricDimensions);

        /**
         * <p>
         * The dimension information returned for requested metric types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.pi.model.MetricDimensionGroups.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.pi.model.MetricDimensionGroups#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.pi.model.MetricDimensionGroups.Builder#build()} is called immediately
         * and its result is passed to {@link #metricDimensions(List<MetricDimensionGroups>)}.
         * 
         * @param metricDimensions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.pi.model.MetricDimensionGroups.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricDimensions(java.util.Collection<MetricDimensionGroups>)
         */
        Builder metricDimensions(Consumer<MetricDimensionGroups.Builder>... metricDimensions);

        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param nextToken
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the token, up to the value specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PiResponse.BuilderImpl implements Builder {
        private List<MetricDimensionGroups> metricDimensions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAvailableResourceDimensionsResponse model) {
            super(model);
            metricDimensions(model.metricDimensions);
            nextToken(model.nextToken);
        }

        public final List<MetricDimensionGroups.Builder> getMetricDimensions() {
            List<MetricDimensionGroups.Builder> result = MetricDimensionsListCopier.copyToBuilder(this.metricDimensions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricDimensions(Collection<MetricDimensionGroups.BuilderImpl> metricDimensions) {
            this.metricDimensions = MetricDimensionsListCopier.copyFromBuilder(metricDimensions);
        }

        @Override
        public final Builder metricDimensions(Collection<MetricDimensionGroups> metricDimensions) {
            this.metricDimensions = MetricDimensionsListCopier.copy(metricDimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDimensions(MetricDimensionGroups... metricDimensions) {
            metricDimensions(Arrays.asList(metricDimensions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDimensions(Consumer<MetricDimensionGroups.Builder>... metricDimensions) {
            metricDimensions(Stream.of(metricDimensions).map(c -> MetricDimensionGroups.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAvailableResourceDimensionsResponse build() {
            return new ListAvailableResourceDimensionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
