/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecipeProvider {
    SERVICE("SERVICE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecipeProvider> VALUE_MAP;
    private final String value;

    private RecipeProvider(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecipeProvider fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecipeProvider> knownValues() {
        EnumSet<RecipeProvider> knownValues = EnumSet.allOf(RecipeProvider.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecipeProvider.class, RecipeProvider::toString);
    }
}

