/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.personalize.model.BatchInferenceJobSummary;
import software.amazon.awssdk.services.personalize.model.BatchInferenceJobsCopier;
import software.amazon.awssdk.services.personalize.model.PersonalizeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBatchInferenceJobsResponse
extends PersonalizeResponse
implements ToCopyableBuilder<Builder, ListBatchInferenceJobsResponse> {
    private static final SdkField<List<BatchInferenceJobSummary>> BATCH_INFERENCE_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("batchInferenceJobs").getter(ListBatchInferenceJobsResponse.getter(ListBatchInferenceJobsResponse::batchInferenceJobs)).setter(ListBatchInferenceJobsResponse.setter(Builder::batchInferenceJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchInferenceJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchInferenceJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBatchInferenceJobsResponse.getter(ListBatchInferenceJobsResponse::nextToken)).setter(ListBatchInferenceJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_INFERENCE_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private final List<BatchInferenceJobSummary> batchInferenceJobs;
    private final String nextToken;

    private ListBatchInferenceJobsResponse(BuilderImpl builder) {
        super(builder);
        this.batchInferenceJobs = builder.batchInferenceJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBatchInferenceJobs() {
        return this.batchInferenceJobs != null && !(this.batchInferenceJobs instanceof SdkAutoConstructList);
    }

    public final List<BatchInferenceJobSummary> batchInferenceJobs() {
        return this.batchInferenceJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBatchInferenceJobs() ? this.batchInferenceJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBatchInferenceJobsResponse)) {
            return false;
        }
        ListBatchInferenceJobsResponse other = (ListBatchInferenceJobsResponse)((Object)obj);
        return this.hasBatchInferenceJobs() == other.hasBatchInferenceJobs() && Objects.equals(this.batchInferenceJobs(), other.batchInferenceJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListBatchInferenceJobsResponse").add("BatchInferenceJobs", this.hasBatchInferenceJobs() ? this.batchInferenceJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "batchInferenceJobs": {
                return Optional.ofNullable(clazz.cast(this.batchInferenceJobs()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListBatchInferenceJobsResponse, T> g) {
        return obj -> g.apply((ListBatchInferenceJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PersonalizeResponse.BuilderImpl
    implements Builder {
        private List<BatchInferenceJobSummary> batchInferenceJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBatchInferenceJobsResponse model) {
            super(model);
            this.batchInferenceJobs(model.batchInferenceJobs);
            this.nextToken(model.nextToken);
        }

        public final List<BatchInferenceJobSummary.Builder> getBatchInferenceJobs() {
            List<BatchInferenceJobSummary.Builder> result = BatchInferenceJobsCopier.copyToBuilder(this.batchInferenceJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBatchInferenceJobs(Collection<BatchInferenceJobSummary.BuilderImpl> batchInferenceJobs) {
            this.batchInferenceJobs = BatchInferenceJobsCopier.copyFromBuilder(batchInferenceJobs);
        }

        @Override
        public final Builder batchInferenceJobs(Collection<BatchInferenceJobSummary> batchInferenceJobs) {
            this.batchInferenceJobs = BatchInferenceJobsCopier.copy(batchInferenceJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchInferenceJobs(BatchInferenceJobSummary ... batchInferenceJobs) {
            this.batchInferenceJobs(Arrays.asList(batchInferenceJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchInferenceJobs(Consumer<BatchInferenceJobSummary.Builder> ... batchInferenceJobs) {
            this.batchInferenceJobs(Stream.of(batchInferenceJobs).map(c -> (BatchInferenceJobSummary)((BatchInferenceJobSummary.Builder)BatchInferenceJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBatchInferenceJobsResponse build() {
            return new ListBatchInferenceJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PersonalizeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBatchInferenceJobsResponse> {
        public Builder batchInferenceJobs(Collection<BatchInferenceJobSummary> var1);

        public Builder batchInferenceJobs(BatchInferenceJobSummary ... var1);

        public Builder batchInferenceJobs(Consumer<BatchInferenceJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

