/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.personalize.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.personalize.PersonalizeAsyncClient;
import software.amazon.awssdk.services.personalize.internal.UserAgentUtils;
import software.amazon.awssdk.services.personalize.model.FilterSummary;
import software.amazon.awssdk.services.personalize.model.ListFiltersRequest;
import software.amazon.awssdk.services.personalize.model.ListFiltersResponse;

public class ListFiltersPublisher
implements SdkPublisher<ListFiltersResponse> {
    private final PersonalizeAsyncClient client;
    private final ListFiltersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFiltersPublisher(PersonalizeAsyncClient client, ListFiltersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFiltersPublisher(PersonalizeAsyncClient client, ListFiltersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFiltersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFiltersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FilterSummary> filters() {
        Function<ListFiltersResponse, Iterator> getIterator = response -> {
            if (response != null && response.filters() != null) {
                return response.filters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFiltersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFiltersResponseFetcher
    implements AsyncPageFetcher<ListFiltersResponse> {
        private ListFiltersResponseFetcher() {
        }

        public boolean hasNextPage(ListFiltersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFiltersResponse> nextPage(ListFiltersResponse previousPage) {
            if (previousPage == null) {
                return ListFiltersPublisher.this.client.listFilters(ListFiltersPublisher.this.firstRequest);
            }
            return ListFiltersPublisher.this.client.listFilters((ListFiltersRequest)((Object)ListFiltersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

