/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters to derive session key value using a MAC EMV algorithm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionKeyDerivationValue implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionKeyDerivationValue.Builder, SessionKeyDerivationValue> {
    private static final SdkField<String> APPLICATION_CRYPTOGRAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationCryptogram").getter(getter(SessionKeyDerivationValue::applicationCryptogram))
            .setter(setter(Builder::applicationCryptogram))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationCryptogram").build())
            .build();

    private static final SdkField<String> APPLICATION_TRANSACTION_COUNTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplicationTransactionCounter")
            .getter(getter(SessionKeyDerivationValue::applicationTransactionCounter))
            .setter(setter(Builder::applicationTransactionCounter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationTransactionCounter")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_CRYPTOGRAM_FIELD,
            APPLICATION_TRANSACTION_COUNTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationCryptogram;

    private final String applicationTransactionCounter;

    private final Type type;

    private SessionKeyDerivationValue(BuilderImpl builder) {
        this.applicationCryptogram = builder.applicationCryptogram;
        this.applicationTransactionCounter = builder.applicationTransactionCounter;
        this.type = builder.type;
    }

    /**
     * <p>
     * The cryptogram provided by the terminal during transaction processing.
     * </p>
     * 
     * @return The cryptogram provided by the terminal during transaction processing.
     */
    public final String applicationCryptogram() {
        return applicationCryptogram;
    }

    /**
     * <p>
     * The transaction counter that is provided by the terminal during transaction processing.
     * </p>
     * 
     * @return The transaction counter that is provided by the terminal during transaction processing.
     */
    public final String applicationTransactionCounter() {
        return applicationTransactionCounter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationCryptogram());
        hashCode = 31 * hashCode + Objects.hashCode(applicationTransactionCounter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionKeyDerivationValue)) {
            return false;
        }
        SessionKeyDerivationValue other = (SessionKeyDerivationValue) obj;
        return Objects.equals(applicationCryptogram(), other.applicationCryptogram())
                && Objects.equals(applicationTransactionCounter(), other.applicationTransactionCounter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionKeyDerivationValue").add("ApplicationCryptogram", applicationCryptogram())
                .add("ApplicationTransactionCounter", applicationTransactionCounter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationCryptogram":
            return Optional.ofNullable(clazz.cast(applicationCryptogram()));
        case "ApplicationTransactionCounter":
            return Optional.ofNullable(clazz.cast(applicationTransactionCounter()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #applicationCryptogram()} initialized to the given value.
     *
     * <p>
     * The cryptogram provided by the terminal during transaction processing.
     * </p>
     * 
     * @param applicationCryptogram
     *        The cryptogram provided by the terminal during transaction processing.
     */
    public static SessionKeyDerivationValue fromApplicationCryptogram(String applicationCryptogram) {
        return builder().applicationCryptogram(applicationCryptogram).build();
    }

    /**
     * Create an instance of this class with {@link #applicationTransactionCounter()} initialized to the given value.
     *
     * <p>
     * The transaction counter that is provided by the terminal during transaction processing.
     * </p>
     * 
     * @param applicationTransactionCounter
     *        The transaction counter that is provided by the terminal during transaction processing.
     */
    public static SessionKeyDerivationValue fromApplicationTransactionCounter(String applicationTransactionCounter) {
        return builder().applicationTransactionCounter(applicationTransactionCounter).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionKeyDerivationValue, T> g) {
        return obj -> g.apply((SessionKeyDerivationValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionKeyDerivationValue> {
        /**
         * <p>
         * The cryptogram provided by the terminal during transaction processing.
         * </p>
         * 
         * @param applicationCryptogram
         *        The cryptogram provided by the terminal during transaction processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationCryptogram(String applicationCryptogram);

        /**
         * <p>
         * The transaction counter that is provided by the terminal during transaction processing.
         * </p>
         * 
         * @param applicationTransactionCounter
         *        The transaction counter that is provided by the terminal during transaction processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationTransactionCounter(String applicationTransactionCounter);
    }

    static final class BuilderImpl implements Builder {
        private String applicationCryptogram;

        private String applicationTransactionCounter;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SessionKeyDerivationValue model) {
            applicationCryptogram(model.applicationCryptogram);
            applicationTransactionCounter(model.applicationTransactionCounter);
        }

        public final String getApplicationCryptogram() {
            return applicationCryptogram;
        }

        public final void setApplicationCryptogram(String applicationCryptogram) {
            Object oldValue = this.applicationCryptogram;
            this.applicationCryptogram = applicationCryptogram;
            handleUnionValueChange(Type.APPLICATION_CRYPTOGRAM, oldValue, this.applicationCryptogram);
        }

        @Override
        public final Builder applicationCryptogram(String applicationCryptogram) {
            Object oldValue = this.applicationCryptogram;
            this.applicationCryptogram = applicationCryptogram;
            handleUnionValueChange(Type.APPLICATION_CRYPTOGRAM, oldValue, this.applicationCryptogram);
            return this;
        }

        public final String getApplicationTransactionCounter() {
            return applicationTransactionCounter;
        }

        public final void setApplicationTransactionCounter(String applicationTransactionCounter) {
            Object oldValue = this.applicationTransactionCounter;
            this.applicationTransactionCounter = applicationTransactionCounter;
            handleUnionValueChange(Type.APPLICATION_TRANSACTION_COUNTER, oldValue, this.applicationTransactionCounter);
        }

        @Override
        public final Builder applicationTransactionCounter(String applicationTransactionCounter) {
            Object oldValue = this.applicationTransactionCounter;
            this.applicationTransactionCounter = applicationTransactionCounter;
            handleUnionValueChange(Type.APPLICATION_TRANSACTION_COUNTER, oldValue, this.applicationTransactionCounter);
            return this;
        }

        @Override
        public SessionKeyDerivationValue build() {
            return new SessionKeyDerivationValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SessionKeyDerivationValue#type()
     */
    public enum Type {
        APPLICATION_CRYPTOGRAM,

        APPLICATION_TRANSACTION_COUNTER,

        UNKNOWN_TO_SDK_VERSION
    }
}
