/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GeneratePinDataResponse extends PaymentCryptographyDataResponse implements
        ToCopyableBuilder<GeneratePinDataResponse.Builder, GeneratePinDataResponse> {
    private static final SdkField<String> ENCRYPTED_PIN_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptedPinBlock").getter(getter(GeneratePinDataResponse::encryptedPinBlock))
            .setter(setter(Builder::encryptedPinBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptedPinBlock").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyArn").getter(getter(GeneratePinDataResponse::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_CHECK_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyCheckValue").getter(getter(GeneratePinDataResponse::encryptionKeyCheckValue))
            .setter(setter(Builder::encryptionKeyCheckValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyCheckValue").build())
            .build();

    private static final SdkField<String> GENERATION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GenerationKeyArn").getter(getter(GeneratePinDataResponse::generationKeyArn))
            .setter(setter(Builder::generationKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationKeyArn").build()).build();

    private static final SdkField<String> GENERATION_KEY_CHECK_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GenerationKeyCheckValue").getter(getter(GeneratePinDataResponse::generationKeyCheckValue))
            .setter(setter(Builder::generationKeyCheckValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationKeyCheckValue").build())
            .build();

    private static final SdkField<PinData> PIN_DATA_FIELD = SdkField.<PinData> builder(MarshallingType.SDK_POJO)
            .memberName("PinData").getter(getter(GeneratePinDataResponse::pinData)).setter(setter(Builder::pinData))
            .constructor(PinData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PinData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTED_PIN_BLOCK_FIELD,
            ENCRYPTION_KEY_ARN_FIELD, ENCRYPTION_KEY_CHECK_VALUE_FIELD, GENERATION_KEY_ARN_FIELD,
            GENERATION_KEY_CHECK_VALUE_FIELD, PIN_DATA_FIELD));

    private final String encryptedPinBlock;

    private final String encryptionKeyArn;

    private final String encryptionKeyCheckValue;

    private final String generationKeyArn;

    private final String generationKeyCheckValue;

    private final PinData pinData;

    private GeneratePinDataResponse(BuilderImpl builder) {
        super(builder);
        this.encryptedPinBlock = builder.encryptedPinBlock;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.encryptionKeyCheckValue = builder.encryptionKeyCheckValue;
        this.generationKeyArn = builder.generationKeyArn;
        this.generationKeyCheckValue = builder.generationKeyCheckValue;
        this.pinData = builder.pinData;
    }

    /**
     * <p>
     * The PIN block encrypted under PEK from Amazon Web Services Payment Cryptography. The encrypted PIN block is a
     * composite of PAN (Primary Account Number) and PIN (Personal Identification Number), generated in accordance with
     * ISO 9564 standard.
     * </p>
     * 
     * @return The PIN block encrypted under PEK from Amazon Web Services Payment Cryptography. The encrypted PIN block
     *         is a composite of PAN (Primary Account Number) and PIN (Personal Identification Number), generated in
     *         accordance with ISO 9564 standard.
     */
    public final String encryptedPinBlock() {
        return encryptedPinBlock;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses for encrypted pin block
     * generation.
     * </p>
     * 
     * @return The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses for encrypted pin
     *         block generation.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have
     * the same key or to detect that a key has changed. Amazon Web Services Payment Cryptography calculates the KCV by
     * using standard algorithms, typically by encrypting 8 or 16 bytes or "00" or "01" and then truncating the result
     * to the first 3 bytes, or 6 hex digits, of the resulting cryptogram.
     * </p>
     * 
     * @return The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given
     *         key have the same key or to detect that a key has changed. Amazon Web Services Payment Cryptography
     *         calculates the KCV by using standard algorithms, typically by encrypting 8 or 16 bytes or "00" or "01"
     *         and then truncating the result to the first 3 bytes, or 6 hex digits, of the resulting cryptogram.
     */
    public final String encryptionKeyCheckValue() {
        return encryptionKeyCheckValue;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the pin data generation key that Amazon Web Services Payment Cryptography uses for
     * PIN, PVV or PIN Offset generation.
     * </p>
     * 
     * @return The <code>keyARN</code> of the pin data generation key that Amazon Web Services Payment Cryptography uses
     *         for PIN, PVV or PIN Offset generation.
     */
    public final String generationKeyArn() {
        return generationKeyArn;
    }

    /**
     * <p>
     * The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key have
     * the same key or to detect that a key has changed. Amazon Web Services Payment Cryptography calculates the KCV by
     * using standard algorithms, typically by encrypting 8 or 16 bytes or "00" or "01" and then truncating the result
     * to the first 3 bytes, or 6 hex digits, of the resulting cryptogram.
     * </p>
     * 
     * @return The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given
     *         key have the same key or to detect that a key has changed. Amazon Web Services Payment Cryptography
     *         calculates the KCV by using standard algorithms, typically by encrypting 8 or 16 bytes or "00" or "01"
     *         and then truncating the result to the first 3 bytes, or 6 hex digits, of the resulting cryptogram.
     */
    public final String generationKeyCheckValue() {
        return generationKeyCheckValue;
    }

    /**
     * <p>
     * The attributes and values Amazon Web Services Payment Cryptography uses for pin data generation.
     * </p>
     * 
     * @return The attributes and values Amazon Web Services Payment Cryptography uses for pin data generation.
     */
    public final PinData pinData() {
        return pinData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(encryptedPinBlock());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyCheckValue());
        hashCode = 31 * hashCode + Objects.hashCode(generationKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(generationKeyCheckValue());
        hashCode = 31 * hashCode + Objects.hashCode(pinData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GeneratePinDataResponse)) {
            return false;
        }
        GeneratePinDataResponse other = (GeneratePinDataResponse) obj;
        return Objects.equals(encryptedPinBlock(), other.encryptedPinBlock())
                && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(encryptionKeyCheckValue(), other.encryptionKeyCheckValue())
                && Objects.equals(generationKeyArn(), other.generationKeyArn())
                && Objects.equals(generationKeyCheckValue(), other.generationKeyCheckValue())
                && Objects.equals(pinData(), other.pinData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GeneratePinDataResponse").add("EncryptedPinBlock", encryptedPinBlock())
                .add("EncryptionKeyArn", encryptionKeyArn()).add("EncryptionKeyCheckValue", encryptionKeyCheckValue())
                .add("GenerationKeyArn", generationKeyArn()).add("GenerationKeyCheckValue", generationKeyCheckValue())
                .add("PinData", pinData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptedPinBlock":
            return Optional.ofNullable(clazz.cast(encryptedPinBlock()));
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "EncryptionKeyCheckValue":
            return Optional.ofNullable(clazz.cast(encryptionKeyCheckValue()));
        case "GenerationKeyArn":
            return Optional.ofNullable(clazz.cast(generationKeyArn()));
        case "GenerationKeyCheckValue":
            return Optional.ofNullable(clazz.cast(generationKeyCheckValue()));
        case "PinData":
            return Optional.ofNullable(clazz.cast(pinData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GeneratePinDataResponse, T> g) {
        return obj -> g.apply((GeneratePinDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PaymentCryptographyDataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GeneratePinDataResponse> {
        /**
         * <p>
         * The PIN block encrypted under PEK from Amazon Web Services Payment Cryptography. The encrypted PIN block is a
         * composite of PAN (Primary Account Number) and PIN (Personal Identification Number), generated in accordance
         * with ISO 9564 standard.
         * </p>
         * 
         * @param encryptedPinBlock
         *        The PIN block encrypted under PEK from Amazon Web Services Payment Cryptography. The encrypted PIN
         *        block is a composite of PAN (Primary Account Number) and PIN (Personal Identification Number),
         *        generated in accordance with ISO 9564 standard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptedPinBlock(String encryptedPinBlock);

        /**
         * <p>
         * The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses for encrypted pin block
         * generation.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The <code>keyARN</code> of the PEK that Amazon Web Services Payment Cryptography uses for encrypted
         *        pin block generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key
         * have the same key or to detect that a key has changed. Amazon Web Services Payment Cryptography calculates
         * the KCV by using standard algorithms, typically by encrypting 8 or 16 bytes or "00" or "01" and then
         * truncating the result to the first 3 bytes, or 6 hex digits, of the resulting cryptogram.
         * </p>
         * 
         * @param encryptionKeyCheckValue
         *        The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a
         *        given key have the same key or to detect that a key has changed. Amazon Web Services Payment
         *        Cryptography calculates the KCV by using standard algorithms, typically by encrypting 8 or 16 bytes or
         *        "00" or "01" and then truncating the result to the first 3 bytes, or 6 hex digits, of the resulting
         *        cryptogram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyCheckValue(String encryptionKeyCheckValue);

        /**
         * <p>
         * The <code>keyARN</code> of the pin data generation key that Amazon Web Services Payment Cryptography uses for
         * PIN, PVV or PIN Offset generation.
         * </p>
         * 
         * @param generationKeyArn
         *        The <code>keyARN</code> of the pin data generation key that Amazon Web Services Payment Cryptography
         *        uses for PIN, PVV or PIN Offset generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationKeyArn(String generationKeyArn);

        /**
         * <p>
         * The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a given key
         * have the same key or to detect that a key has changed. Amazon Web Services Payment Cryptography calculates
         * the KCV by using standard algorithms, typically by encrypting 8 or 16 bytes or "00" or "01" and then
         * truncating the result to the first 3 bytes, or 6 hex digits, of the resulting cryptogram.
         * </p>
         * 
         * @param generationKeyCheckValue
         *        The key check value (KCV) of the encryption key. The KCV is used to check if all parties holding a
         *        given key have the same key or to detect that a key has changed. Amazon Web Services Payment
         *        Cryptography calculates the KCV by using standard algorithms, typically by encrypting 8 or 16 bytes or
         *        "00" or "01" and then truncating the result to the first 3 bytes, or 6 hex digits, of the resulting
         *        cryptogram.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationKeyCheckValue(String generationKeyCheckValue);

        /**
         * <p>
         * The attributes and values Amazon Web Services Payment Cryptography uses for pin data generation.
         * </p>
         * 
         * @param pinData
         *        The attributes and values Amazon Web Services Payment Cryptography uses for pin data generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pinData(PinData pinData);

        /**
         * <p>
         * The attributes and values Amazon Web Services Payment Cryptography uses for pin data generation.
         * </p>
         * This is a convenience method that creates an instance of the {@link PinData.Builder} avoiding the need to
         * create one manually via {@link PinData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PinData.Builder#build()} is called immediately and its result is
         * passed to {@link #pinData(PinData)}.
         * 
         * @param pinData
         *        a consumer that will call methods on {@link PinData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pinData(PinData)
         */
        default Builder pinData(Consumer<PinData.Builder> pinData) {
            return pinData(PinData.builder().applyMutation(pinData).build());
        }
    }

    static final class BuilderImpl extends PaymentCryptographyDataResponse.BuilderImpl implements Builder {
        private String encryptedPinBlock;

        private String encryptionKeyArn;

        private String encryptionKeyCheckValue;

        private String generationKeyArn;

        private String generationKeyCheckValue;

        private PinData pinData;

        private BuilderImpl() {
        }

        private BuilderImpl(GeneratePinDataResponse model) {
            super(model);
            encryptedPinBlock(model.encryptedPinBlock);
            encryptionKeyArn(model.encryptionKeyArn);
            encryptionKeyCheckValue(model.encryptionKeyCheckValue);
            generationKeyArn(model.generationKeyArn);
            generationKeyCheckValue(model.generationKeyCheckValue);
            pinData(model.pinData);
        }

        public final String getEncryptedPinBlock() {
            return encryptedPinBlock;
        }

        public final void setEncryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
        }

        @Override
        public final Builder encryptedPinBlock(String encryptedPinBlock) {
            this.encryptedPinBlock = encryptedPinBlock;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getEncryptionKeyCheckValue() {
            return encryptionKeyCheckValue;
        }

        public final void setEncryptionKeyCheckValue(String encryptionKeyCheckValue) {
            this.encryptionKeyCheckValue = encryptionKeyCheckValue;
        }

        @Override
        public final Builder encryptionKeyCheckValue(String encryptionKeyCheckValue) {
            this.encryptionKeyCheckValue = encryptionKeyCheckValue;
            return this;
        }

        public final String getGenerationKeyArn() {
            return generationKeyArn;
        }

        public final void setGenerationKeyArn(String generationKeyArn) {
            this.generationKeyArn = generationKeyArn;
        }

        @Override
        public final Builder generationKeyArn(String generationKeyArn) {
            this.generationKeyArn = generationKeyArn;
            return this;
        }

        public final String getGenerationKeyCheckValue() {
            return generationKeyCheckValue;
        }

        public final void setGenerationKeyCheckValue(String generationKeyCheckValue) {
            this.generationKeyCheckValue = generationKeyCheckValue;
        }

        @Override
        public final Builder generationKeyCheckValue(String generationKeyCheckValue) {
            this.generationKeyCheckValue = generationKeyCheckValue;
            return this;
        }

        public final PinData.Builder getPinData() {
            return pinData != null ? pinData.toBuilder() : null;
        }

        public final void setPinData(PinData.BuilderImpl pinData) {
            this.pinData = pinData != null ? pinData.build() : null;
        }

        @Override
        public final Builder pinData(PinData pinData) {
            this.pinData = pinData;
            return this;
        }

        @Override
        public GeneratePinDataResponse build() {
            return new GeneratePinDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
