/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateMacRequest extends PaymentCryptographyDataRequest implements
        ToCopyableBuilder<GenerateMacRequest.Builder, GenerateMacRequest> {
    private static final SdkField<MacAttributes> GENERATION_ATTRIBUTES_FIELD = SdkField
            .<MacAttributes> builder(MarshallingType.SDK_POJO).memberName("GenerationAttributes")
            .getter(getter(GenerateMacRequest::generationAttributes)).setter(setter(Builder::generationAttributes))
            .constructor(MacAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationAttributes").build())
            .build();

    private static final SdkField<String> KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyIdentifier").getter(getter(GenerateMacRequest::keyIdentifier)).setter(setter(Builder::keyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyIdentifier").build()).build();

    private static final SdkField<Integer> MAC_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MacLength").getter(getter(GenerateMacRequest::macLength)).setter(setter(Builder::macLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacLength").build()).build();

    private static final SdkField<String> MESSAGE_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageData").getter(getter(GenerateMacRequest::messageData)).setter(setter(Builder::messageData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageData").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATION_ATTRIBUTES_FIELD,
            KEY_IDENTIFIER_FIELD, MAC_LENGTH_FIELD, MESSAGE_DATA_FIELD));

    private final MacAttributes generationAttributes;

    private final String keyIdentifier;

    private final Integer macLength;

    private final String messageData;

    private GenerateMacRequest(BuilderImpl builder) {
        super(builder);
        this.generationAttributes = builder.generationAttributes;
        this.keyIdentifier = builder.keyIdentifier;
        this.macLength = builder.macLength;
        this.messageData = builder.messageData;
    }

    /**
     * <p>
     * The attributes and data values to use for MAC generation within Amazon Web Services Payment Cryptography.
     * </p>
     * 
     * @return The attributes and data values to use for MAC generation within Amazon Web Services Payment Cryptography.
     */
    public final MacAttributes generationAttributes() {
        return generationAttributes;
    }

    /**
     * <p>
     * The <code>keyARN</code> of the MAC generation encryption key.
     * </p>
     * 
     * @return The <code>keyARN</code> of the MAC generation encryption key.
     */
    public final String keyIdentifier() {
        return keyIdentifier;
    }

    /**
     * <p>
     * The length of a MAC under generation.
     * </p>
     * 
     * @return The length of a MAC under generation.
     */
    public final Integer macLength() {
        return macLength;
    }

    /**
     * <p>
     * The data for which a MAC is under generation.
     * </p>
     * 
     * @return The data for which a MAC is under generation.
     */
    public final String messageData() {
        return messageData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(generationAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(keyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(macLength());
        hashCode = 31 * hashCode + Objects.hashCode(messageData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateMacRequest)) {
            return false;
        }
        GenerateMacRequest other = (GenerateMacRequest) obj;
        return Objects.equals(generationAttributes(), other.generationAttributes())
                && Objects.equals(keyIdentifier(), other.keyIdentifier()) && Objects.equals(macLength(), other.macLength())
                && Objects.equals(messageData(), other.messageData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateMacRequest").add("GenerationAttributes", generationAttributes())
                .add("KeyIdentifier", keyIdentifier()).add("MacLength", macLength()).add("MessageData", messageData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GenerationAttributes":
            return Optional.ofNullable(clazz.cast(generationAttributes()));
        case "KeyIdentifier":
            return Optional.ofNullable(clazz.cast(keyIdentifier()));
        case "MacLength":
            return Optional.ofNullable(clazz.cast(macLength()));
        case "MessageData":
            return Optional.ofNullable(clazz.cast(messageData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerateMacRequest, T> g) {
        return obj -> g.apply((GenerateMacRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PaymentCryptographyDataRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GenerateMacRequest> {
        /**
         * <p>
         * The attributes and data values to use for MAC generation within Amazon Web Services Payment Cryptography.
         * </p>
         * 
         * @param generationAttributes
         *        The attributes and data values to use for MAC generation within Amazon Web Services Payment
         *        Cryptography.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationAttributes(MacAttributes generationAttributes);

        /**
         * <p>
         * The attributes and data values to use for MAC generation within Amazon Web Services Payment Cryptography.
         * </p>
         * This is a convenience method that creates an instance of the {@link MacAttributes.Builder} avoiding the need
         * to create one manually via {@link MacAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MacAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #generationAttributes(MacAttributes)}.
         * 
         * @param generationAttributes
         *        a consumer that will call methods on {@link MacAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generationAttributes(MacAttributes)
         */
        default Builder generationAttributes(Consumer<MacAttributes.Builder> generationAttributes) {
            return generationAttributes(MacAttributes.builder().applyMutation(generationAttributes).build());
        }

        /**
         * <p>
         * The <code>keyARN</code> of the MAC generation encryption key.
         * </p>
         * 
         * @param keyIdentifier
         *        The <code>keyARN</code> of the MAC generation encryption key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyIdentifier(String keyIdentifier);

        /**
         * <p>
         * The length of a MAC under generation.
         * </p>
         * 
         * @param macLength
         *        The length of a MAC under generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder macLength(Integer macLength);

        /**
         * <p>
         * The data for which a MAC is under generation.
         * </p>
         * 
         * @param messageData
         *        The data for which a MAC is under generation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageData(String messageData);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PaymentCryptographyDataRequest.BuilderImpl implements Builder {
        private MacAttributes generationAttributes;

        private String keyIdentifier;

        private Integer macLength;

        private String messageData;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateMacRequest model) {
            super(model);
            generationAttributes(model.generationAttributes);
            keyIdentifier(model.keyIdentifier);
            macLength(model.macLength);
            messageData(model.messageData);
        }

        public final MacAttributes.Builder getGenerationAttributes() {
            return generationAttributes != null ? generationAttributes.toBuilder() : null;
        }

        public final void setGenerationAttributes(MacAttributes.BuilderImpl generationAttributes) {
            this.generationAttributes = generationAttributes != null ? generationAttributes.build() : null;
        }

        @Override
        public final Builder generationAttributes(MacAttributes generationAttributes) {
            this.generationAttributes = generationAttributes;
            return this;
        }

        public final String getKeyIdentifier() {
            return keyIdentifier;
        }

        public final void setKeyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
        }

        @Override
        public final Builder keyIdentifier(String keyIdentifier) {
            this.keyIdentifier = keyIdentifier;
            return this;
        }

        public final Integer getMacLength() {
            return macLength;
        }

        public final void setMacLength(Integer macLength) {
            this.macLength = macLength;
        }

        @Override
        public final Builder macLength(Integer macLength) {
            this.macLength = macLength;
            return this;
        }

        public final String getMessageData() {
            return messageData;
        }

        public final void setMessageData(String messageData) {
            this.messageData = messageData;
        }

        @Override
        public final Builder messageData(String messageData) {
            this.messageData = messageData;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateMacRequest build() {
            return new GenerateMacRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
