/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters that are required for ARPC response generation using method2 after ARQC verification is successful.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CryptogramVerificationArpcMethod2 implements SdkPojo, Serializable,
        ToCopyableBuilder<CryptogramVerificationArpcMethod2.Builder, CryptogramVerificationArpcMethod2> {
    private static final SdkField<String> CARD_STATUS_UPDATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CardStatusUpdate").getter(getter(CryptogramVerificationArpcMethod2::cardStatusUpdate))
            .setter(setter(Builder::cardStatusUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CardStatusUpdate").build()).build();

    private static final SdkField<String> PROPRIETARY_AUTHENTICATION_DATA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProprietaryAuthenticationData")
            .getter(getter(CryptogramVerificationArpcMethod2::proprietaryAuthenticationData))
            .setter(setter(Builder::proprietaryAuthenticationData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProprietaryAuthenticationData")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CARD_STATUS_UPDATE_FIELD,
            PROPRIETARY_AUTHENTICATION_DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cardStatusUpdate;

    private final String proprietaryAuthenticationData;

    private CryptogramVerificationArpcMethod2(BuilderImpl builder) {
        this.cardStatusUpdate = builder.cardStatusUpdate;
        this.proprietaryAuthenticationData = builder.proprietaryAuthenticationData;
    }

    /**
     * <p>
     * The data indicating whether the issuer approves or declines an online transaction using an EMV chip card.
     * </p>
     * 
     * @return The data indicating whether the issuer approves or declines an online transaction using an EMV chip card.
     */
    public final String cardStatusUpdate() {
        return cardStatusUpdate;
    }

    /**
     * <p>
     * The proprietary authentication data used by issuer for communication during online transaction using an EMV chip
     * card.
     * </p>
     * 
     * @return The proprietary authentication data used by issuer for communication during online transaction using an
     *         EMV chip card.
     */
    public final String proprietaryAuthenticationData() {
        return proprietaryAuthenticationData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cardStatusUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(proprietaryAuthenticationData());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CryptogramVerificationArpcMethod2)) {
            return false;
        }
        CryptogramVerificationArpcMethod2 other = (CryptogramVerificationArpcMethod2) obj;
        return Objects.equals(cardStatusUpdate(), other.cardStatusUpdate())
                && Objects.equals(proprietaryAuthenticationData(), other.proprietaryAuthenticationData());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CryptogramVerificationArpcMethod2").add("CardStatusUpdate", cardStatusUpdate())
                .add("ProprietaryAuthenticationData", proprietaryAuthenticationData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CardStatusUpdate":
            return Optional.ofNullable(clazz.cast(cardStatusUpdate()));
        case "ProprietaryAuthenticationData":
            return Optional.ofNullable(clazz.cast(proprietaryAuthenticationData()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CryptogramVerificationArpcMethod2, T> g) {
        return obj -> g.apply((CryptogramVerificationArpcMethod2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CryptogramVerificationArpcMethod2> {
        /**
         * <p>
         * The data indicating whether the issuer approves or declines an online transaction using an EMV chip card.
         * </p>
         * 
         * @param cardStatusUpdate
         *        The data indicating whether the issuer approves or declines an online transaction using an EMV chip
         *        card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cardStatusUpdate(String cardStatusUpdate);

        /**
         * <p>
         * The proprietary authentication data used by issuer for communication during online transaction using an EMV
         * chip card.
         * </p>
         * 
         * @param proprietaryAuthenticationData
         *        The proprietary authentication data used by issuer for communication during online transaction using
         *        an EMV chip card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proprietaryAuthenticationData(String proprietaryAuthenticationData);
    }

    static final class BuilderImpl implements Builder {
        private String cardStatusUpdate;

        private String proprietaryAuthenticationData;

        private BuilderImpl() {
        }

        private BuilderImpl(CryptogramVerificationArpcMethod2 model) {
            cardStatusUpdate(model.cardStatusUpdate);
            proprietaryAuthenticationData(model.proprietaryAuthenticationData);
        }

        public final String getCardStatusUpdate() {
            return cardStatusUpdate;
        }

        public final void setCardStatusUpdate(String cardStatusUpdate) {
            this.cardStatusUpdate = cardStatusUpdate;
        }

        @Override
        public final Builder cardStatusUpdate(String cardStatusUpdate) {
            this.cardStatusUpdate = cardStatusUpdate;
            return this;
        }

        public final String getProprietaryAuthenticationData() {
            return proprietaryAuthenticationData;
        }

        public final void setProprietaryAuthenticationData(String proprietaryAuthenticationData) {
            this.proprietaryAuthenticationData = proprietaryAuthenticationData;
        }

        @Override
        public final Builder proprietaryAuthenticationData(String proprietaryAuthenticationData) {
            this.proprietaryAuthenticationData = proprietaryAuthenticationData;
            return this;
        }

        @Override
        public CryptogramVerificationArpcMethod2 build() {
            return new CryptogramVerificationArpcMethod2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
