/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptographydata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Card data parameters that are required to generate a cardholder verification value for the payment card.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CardHolderVerificationValue implements SdkPojo, Serializable,
        ToCopyableBuilder<CardHolderVerificationValue.Builder, CardHolderVerificationValue> {
    private static final SdkField<String> APPLICATION_TRANSACTION_COUNTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApplicationTransactionCounter")
            .getter(getter(CardHolderVerificationValue::applicationTransactionCounter))
            .setter(setter(Builder::applicationTransactionCounter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationTransactionCounter")
                    .build()).build();

    private static final SdkField<String> PAN_SEQUENCE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PanSequenceNumber").getter(getter(CardHolderVerificationValue::panSequenceNumber))
            .setter(setter(Builder::panSequenceNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PanSequenceNumber").build()).build();

    private static final SdkField<String> UNPREDICTABLE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UnpredictableNumber").getter(getter(CardHolderVerificationValue::unpredictableNumber))
            .setter(setter(Builder::unpredictableNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnpredictableNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPLICATION_TRANSACTION_COUNTER_FIELD, PAN_SEQUENCE_NUMBER_FIELD, UNPREDICTABLE_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String applicationTransactionCounter;

    private final String panSequenceNumber;

    private final String unpredictableNumber;

    private CardHolderVerificationValue(BuilderImpl builder) {
        this.applicationTransactionCounter = builder.applicationTransactionCounter;
        this.panSequenceNumber = builder.panSequenceNumber;
        this.unpredictableNumber = builder.unpredictableNumber;
    }

    /**
     * <p>
     * The transaction counter value that comes from a point of sale terminal.
     * </p>
     * 
     * @return The transaction counter value that comes from a point of sale terminal.
     */
    public final String applicationTransactionCounter() {
        return applicationTransactionCounter;
    }

    /**
     * <p>
     * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     * </p>
     * 
     * @return A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
     */
    public final String panSequenceNumber() {
        return panSequenceNumber;
    }

    /**
     * <p>
     * A random number generated by the issuer.
     * </p>
     * 
     * @return A random number generated by the issuer.
     */
    public final String unpredictableNumber() {
        return unpredictableNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationTransactionCounter());
        hashCode = 31 * hashCode + Objects.hashCode(panSequenceNumber());
        hashCode = 31 * hashCode + Objects.hashCode(unpredictableNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CardHolderVerificationValue)) {
            return false;
        }
        CardHolderVerificationValue other = (CardHolderVerificationValue) obj;
        return Objects.equals(applicationTransactionCounter(), other.applicationTransactionCounter())
                && Objects.equals(panSequenceNumber(), other.panSequenceNumber())
                && Objects.equals(unpredictableNumber(), other.unpredictableNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CardHolderVerificationValue")
                .add("ApplicationTransactionCounter", applicationTransactionCounter())
                .add("PanSequenceNumber", panSequenceNumber()).add("UnpredictableNumber", unpredictableNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationTransactionCounter":
            return Optional.ofNullable(clazz.cast(applicationTransactionCounter()));
        case "PanSequenceNumber":
            return Optional.ofNullable(clazz.cast(panSequenceNumber()));
        case "UnpredictableNumber":
            return Optional.ofNullable(clazz.cast(unpredictableNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CardHolderVerificationValue, T> g) {
        return obj -> g.apply((CardHolderVerificationValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CardHolderVerificationValue> {
        /**
         * <p>
         * The transaction counter value that comes from a point of sale terminal.
         * </p>
         * 
         * @param applicationTransactionCounter
         *        The transaction counter value that comes from a point of sale terminal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationTransactionCounter(String applicationTransactionCounter);

        /**
         * <p>
         * A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
         * </p>
         * 
         * @param panSequenceNumber
         *        A number that identifies and differentiates payment cards with the same Primary Account Number (PAN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder panSequenceNumber(String panSequenceNumber);

        /**
         * <p>
         * A random number generated by the issuer.
         * </p>
         * 
         * @param unpredictableNumber
         *        A random number generated by the issuer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unpredictableNumber(String unpredictableNumber);
    }

    static final class BuilderImpl implements Builder {
        private String applicationTransactionCounter;

        private String panSequenceNumber;

        private String unpredictableNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CardHolderVerificationValue model) {
            applicationTransactionCounter(model.applicationTransactionCounter);
            panSequenceNumber(model.panSequenceNumber);
            unpredictableNumber(model.unpredictableNumber);
        }

        public final String getApplicationTransactionCounter() {
            return applicationTransactionCounter;
        }

        public final void setApplicationTransactionCounter(String applicationTransactionCounter) {
            this.applicationTransactionCounter = applicationTransactionCounter;
        }

        @Override
        public final Builder applicationTransactionCounter(String applicationTransactionCounter) {
            this.applicationTransactionCounter = applicationTransactionCounter;
            return this;
        }

        public final String getPanSequenceNumber() {
            return panSequenceNumber;
        }

        public final void setPanSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
        }

        @Override
        public final Builder panSequenceNumber(String panSequenceNumber) {
            this.panSequenceNumber = panSequenceNumber;
            return this;
        }

        public final String getUnpredictableNumber() {
            return unpredictableNumber;
        }

        public final void setUnpredictableNumber(String unpredictableNumber) {
            this.unpredictableNumber = unpredictableNumber;
        }

        @Override
        public final Builder unpredictableNumber(String unpredictableNumber) {
            this.unpredictableNumber = unpredictableNumber;
            return this;
        }

        @Override
        public CardHolderVerificationValue build() {
            return new CardHolderVerificationValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
