/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KeyOrigin {
    EXTERNAL("EXTERNAL"),
    AWS_PAYMENT_CRYPTOGRAPHY("AWS_PAYMENT_CRYPTOGRAPHY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KeyOrigin> VALUE_MAP;
    private final String value;

    private KeyOrigin(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KeyOrigin fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KeyOrigin> knownValues() {
        EnumSet<KeyOrigin> knownValues = EnumSet.allOf(KeyOrigin.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KeyOrigin.class, KeyOrigin::toString);
    }
}

