/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.paymentcryptography.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameter information for root public key certificate import.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RootCertificatePublicKey implements SdkPojo, Serializable,
        ToCopyableBuilder<RootCertificatePublicKey.Builder, RootCertificatePublicKey> {
    private static final SdkField<KeyAttributes> KEY_ATTRIBUTES_FIELD = SdkField
            .<KeyAttributes> builder(MarshallingType.SDK_POJO).memberName("KeyAttributes")
            .getter(getter(RootCertificatePublicKey::keyAttributes)).setter(setter(Builder::keyAttributes))
            .constructor(KeyAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAttributes").build()).build();

    private static final SdkField<String> PUBLIC_KEY_CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicKeyCertificate").getter(getter(RootCertificatePublicKey::publicKeyCertificate))
            .setter(setter(Builder::publicKeyCertificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyCertificate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ATTRIBUTES_FIELD,
            PUBLIC_KEY_CERTIFICATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final KeyAttributes keyAttributes;

    private final String publicKeyCertificate;

    private RootCertificatePublicKey(BuilderImpl builder) {
        this.keyAttributes = builder.keyAttributes;
        this.publicKeyCertificate = builder.publicKeyCertificate;
    }

    /**
     * <p>
     * The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key. This data
     * is immutable after the root public key is imported.
     * </p>
     * 
     * @return The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
     *         This data is immutable after the root public key is imported.
     */
    public final KeyAttributes keyAttributes() {
        return keyAttributes;
    }

    /**
     * <p>
     * Parameter information for root public key certificate import.
     * </p>
     * 
     * @return Parameter information for root public key certificate import.
     */
    public final String publicKeyCertificate() {
        return publicKeyCertificate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(publicKeyCertificate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RootCertificatePublicKey)) {
            return false;
        }
        RootCertificatePublicKey other = (RootCertificatePublicKey) obj;
        return Objects.equals(keyAttributes(), other.keyAttributes())
                && Objects.equals(publicKeyCertificate(), other.publicKeyCertificate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RootCertificatePublicKey").add("KeyAttributes", keyAttributes())
                .add("PublicKeyCertificate", publicKeyCertificate() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyAttributes":
            return Optional.ofNullable(clazz.cast(keyAttributes()));
        case "PublicKeyCertificate":
            return Optional.ofNullable(clazz.cast(publicKeyCertificate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RootCertificatePublicKey, T> g) {
        return obj -> g.apply((RootCertificatePublicKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RootCertificatePublicKey> {
        /**
         * <p>
         * The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key. This
         * data is immutable after the root public key is imported.
         * </p>
         * 
         * @param keyAttributes
         *        The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key.
         *        This data is immutable after the root public key is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyAttributes(KeyAttributes keyAttributes);

        /**
         * <p>
         * The role of the key, the algorithm it supports, and the cryptographic operations allowed with the key. This
         * data is immutable after the root public key is imported.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyAttributes.Builder} avoiding the need
         * to create one manually via {@link KeyAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyAttributes.Builder#build()} is called immediately and its
         * result is passed to {@link #keyAttributes(KeyAttributes)}.
         * 
         * @param keyAttributes
         *        a consumer that will call methods on {@link KeyAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyAttributes(KeyAttributes)
         */
        default Builder keyAttributes(Consumer<KeyAttributes.Builder> keyAttributes) {
            return keyAttributes(KeyAttributes.builder().applyMutation(keyAttributes).build());
        }

        /**
         * <p>
         * Parameter information for root public key certificate import.
         * </p>
         * 
         * @param publicKeyCertificate
         *        Parameter information for root public key certificate import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyCertificate(String publicKeyCertificate);
    }

    static final class BuilderImpl implements Builder {
        private KeyAttributes keyAttributes;

        private String publicKeyCertificate;

        private BuilderImpl() {
        }

        private BuilderImpl(RootCertificatePublicKey model) {
            keyAttributes(model.keyAttributes);
            publicKeyCertificate(model.publicKeyCertificate);
        }

        public final KeyAttributes.Builder getKeyAttributes() {
            return keyAttributes != null ? keyAttributes.toBuilder() : null;
        }

        public final void setKeyAttributes(KeyAttributes.BuilderImpl keyAttributes) {
            this.keyAttributes = keyAttributes != null ? keyAttributes.build() : null;
        }

        @Override
        public final Builder keyAttributes(KeyAttributes keyAttributes) {
            this.keyAttributes = keyAttributes;
            return this;
        }

        public final String getPublicKeyCertificate() {
            return publicKeyCertificate;
        }

        public final void setPublicKeyCertificate(String publicKeyCertificate) {
            this.publicKeyCertificate = publicKeyCertificate;
        }

        @Override
        public final Builder publicKeyCertificate(String publicKeyCertificate) {
            this.publicKeyCertificate = publicKeyCertificate;
            return this;
        }

        @Override
        public RootCertificatePublicKey build() {
            return new RootCertificatePublicKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
