/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.paymentcryptography.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.paymentcryptography.model.KeyAlgorithm;
import software.amazon.awssdk.services.paymentcryptography.model.KeyMaterialType;
import software.amazon.awssdk.services.paymentcryptography.model.PaymentCryptographyRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetParametersForImportRequest
extends PaymentCryptographyRequest
implements ToCopyableBuilder<Builder, GetParametersForImportRequest> {
    private static final SdkField<String> KEY_MATERIAL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyMaterialType").getter(GetParametersForImportRequest.getter(GetParametersForImportRequest::keyMaterialTypeAsString)).setter(GetParametersForImportRequest.setter(Builder::keyMaterialType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyMaterialType").build()}).build();
    private static final SdkField<String> WRAPPING_KEY_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WrappingKeyAlgorithm").getter(GetParametersForImportRequest.getter(GetParametersForImportRequest::wrappingKeyAlgorithmAsString)).setter(GetParametersForImportRequest.setter(Builder::wrappingKeyAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WrappingKeyAlgorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_MATERIAL_TYPE_FIELD, WRAPPING_KEY_ALGORITHM_FIELD));
    private final String keyMaterialType;
    private final String wrappingKeyAlgorithm;

    private GetParametersForImportRequest(BuilderImpl builder) {
        super(builder);
        this.keyMaterialType = builder.keyMaterialType;
        this.wrappingKeyAlgorithm = builder.wrappingKeyAlgorithm;
    }

    public final KeyMaterialType keyMaterialType() {
        return KeyMaterialType.fromValue(this.keyMaterialType);
    }

    public final String keyMaterialTypeAsString() {
        return this.keyMaterialType;
    }

    public final KeyAlgorithm wrappingKeyAlgorithm() {
        return KeyAlgorithm.fromValue(this.wrappingKeyAlgorithm);
    }

    public final String wrappingKeyAlgorithmAsString() {
        return this.wrappingKeyAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.keyMaterialTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.wrappingKeyAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetParametersForImportRequest)) {
            return false;
        }
        GetParametersForImportRequest other = (GetParametersForImportRequest)((Object)obj);
        return Objects.equals(this.keyMaterialTypeAsString(), other.keyMaterialTypeAsString()) && Objects.equals(this.wrappingKeyAlgorithmAsString(), other.wrappingKeyAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetParametersForImportRequest").add("KeyMaterialType", (Object)this.keyMaterialTypeAsString()).add("WrappingKeyAlgorithm", (Object)this.wrappingKeyAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyMaterialType": {
                return Optional.ofNullable(clazz.cast(this.keyMaterialTypeAsString()));
            }
            case "WrappingKeyAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.wrappingKeyAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetParametersForImportRequest, T> g) {
        return obj -> g.apply((GetParametersForImportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PaymentCryptographyRequest.BuilderImpl
    implements Builder {
        private String keyMaterialType;
        private String wrappingKeyAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(GetParametersForImportRequest model) {
            super(model);
            this.keyMaterialType(model.keyMaterialType);
            this.wrappingKeyAlgorithm(model.wrappingKeyAlgorithm);
        }

        public final String getKeyMaterialType() {
            return this.keyMaterialType;
        }

        public final void setKeyMaterialType(String keyMaterialType) {
            this.keyMaterialType = keyMaterialType;
        }

        @Override
        public final Builder keyMaterialType(String keyMaterialType) {
            this.keyMaterialType = keyMaterialType;
            return this;
        }

        @Override
        public final Builder keyMaterialType(KeyMaterialType keyMaterialType) {
            this.keyMaterialType(keyMaterialType == null ? null : keyMaterialType.toString());
            return this;
        }

        public final String getWrappingKeyAlgorithm() {
            return this.wrappingKeyAlgorithm;
        }

        public final void setWrappingKeyAlgorithm(String wrappingKeyAlgorithm) {
            this.wrappingKeyAlgorithm = wrappingKeyAlgorithm;
        }

        @Override
        public final Builder wrappingKeyAlgorithm(String wrappingKeyAlgorithm) {
            this.wrappingKeyAlgorithm = wrappingKeyAlgorithm;
            return this;
        }

        @Override
        public final Builder wrappingKeyAlgorithm(KeyAlgorithm wrappingKeyAlgorithm) {
            this.wrappingKeyAlgorithm(wrappingKeyAlgorithm == null ? null : wrappingKeyAlgorithm.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetParametersForImportRequest build() {
            return new GetParametersForImportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PaymentCryptographyRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetParametersForImportRequest> {
        public Builder keyMaterialType(String var1);

        public Builder keyMaterialType(KeyMaterialType var1);

        public Builder wrappingKeyAlgorithm(String var1);

        public Builder wrappingKeyAlgorithm(KeyAlgorithm var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

