/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.panorama.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.panorama.model.ApplicationInstance;
import software.amazon.awssdk.services.panorama.model.ApplicationInstancesCopier;
import software.amazon.awssdk.services.panorama.model.PanoramaResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApplicationInstancesResponse
extends PanoramaResponse
implements ToCopyableBuilder<Builder, ListApplicationInstancesResponse> {
    private static final SdkField<List<ApplicationInstance>> APPLICATION_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ApplicationInstances").getter(ListApplicationInstancesResponse.getter(ListApplicationInstancesResponse::applicationInstances)).setter(ListApplicationInstancesResponse.setter(Builder::applicationInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApplicationInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListApplicationInstancesResponse.getter(ListApplicationInstancesResponse::nextToken)).setter(ListApplicationInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_INSTANCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ApplicationInstance> applicationInstances;
    private final String nextToken;

    private ListApplicationInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.applicationInstances = builder.applicationInstances;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasApplicationInstances() {
        return this.applicationInstances != null && !(this.applicationInstances instanceof SdkAutoConstructList);
    }

    public final List<ApplicationInstance> applicationInstances() {
        return this.applicationInstances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationInstances() ? this.applicationInstances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationInstancesResponse)) {
            return false;
        }
        ListApplicationInstancesResponse other = (ListApplicationInstancesResponse)((Object)obj);
        return this.hasApplicationInstances() == other.hasApplicationInstances() && Objects.equals(this.applicationInstances(), other.applicationInstances()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListApplicationInstancesResponse").add("ApplicationInstances", this.hasApplicationInstances() ? this.applicationInstances() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationInstances": {
                return Optional.ofNullable(clazz.cast(this.applicationInstances()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApplicationInstancesResponse, T> g) {
        return obj -> g.apply((ListApplicationInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PanoramaResponse.BuilderImpl
    implements Builder {
        private List<ApplicationInstance> applicationInstances = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationInstancesResponse model) {
            super(model);
            this.applicationInstances(model.applicationInstances);
            this.nextToken(model.nextToken);
        }

        public final List<ApplicationInstance.Builder> getApplicationInstances() {
            List<ApplicationInstance.Builder> result = ApplicationInstancesCopier.copyToBuilder(this.applicationInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApplicationInstances(Collection<ApplicationInstance.BuilderImpl> applicationInstances) {
            this.applicationInstances = ApplicationInstancesCopier.copyFromBuilder(applicationInstances);
        }

        @Override
        public final Builder applicationInstances(Collection<ApplicationInstance> applicationInstances) {
            this.applicationInstances = ApplicationInstancesCopier.copy(applicationInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationInstances(ApplicationInstance ... applicationInstances) {
            this.applicationInstances(Arrays.asList(applicationInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationInstances(Consumer<ApplicationInstance.Builder> ... applicationInstances) {
            this.applicationInstances(Stream.of(applicationInstances).map(c -> (ApplicationInstance)((ApplicationInstance.Builder)ApplicationInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApplicationInstancesResponse build() {
            return new ListApplicationInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends PanoramaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApplicationInstancesResponse> {
        public Builder applicationInstances(Collection<ApplicationInstance> var1);

        public Builder applicationInstances(ApplicationInstance ... var1);

        public Builder applicationInstances(Consumer<ApplicationInstance.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

