/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.organizations.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAwsServiceAccessForOrganizationResponse extends OrganizationsResponse implements
        ToCopyableBuilder<ListAwsServiceAccessForOrganizationResponse.Builder, ListAwsServiceAccessForOrganizationResponse> {
    private static final SdkField<List<EnabledServicePrincipal>> ENABLED_SERVICE_PRINCIPALS_FIELD = SdkField
            .<List<EnabledServicePrincipal>> builder(MarshallingType.LIST)
            .memberName("EnabledServicePrincipals")
            .getter(getter(ListAwsServiceAccessForOrganizationResponse::enabledServicePrincipals))
            .setter(setter(Builder::enabledServicePrincipals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledServicePrincipals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnabledServicePrincipal> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnabledServicePrincipal::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAwsServiceAccessForOrganizationResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENABLED_SERVICE_PRINCIPALS_FIELD, NEXT_TOKEN_FIELD));

    private final List<EnabledServicePrincipal> enabledServicePrincipals;

    private final String nextToken;

    private ListAwsServiceAccessForOrganizationResponse(BuilderImpl builder) {
        super(builder);
        this.enabledServicePrincipals = builder.enabledServicePrincipals;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledServicePrincipals property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnabledServicePrincipals() {
        return enabledServicePrincipals != null && !(enabledServicePrincipals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the service principals for the services that are enabled to integrate with your organization. Each
     * principal is a structure that includes the name and the date that it was enabled for integration with
     * Organizations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledServicePrincipals} method.
     * </p>
     * 
     * @return A list of the service principals for the services that are enabled to integrate with your organization.
     *         Each principal is a structure that includes the name and the date that it was enabled for integration
     *         with Organizations.
     */
    public final List<EnabledServicePrincipal> enabledServicePrincipals() {
        return enabledServicePrincipals;
    }

    /**
     * <p>
     * If present, indicates that more output is available than is included in the current response. Use this value in
     * the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of the
     * output. You should repeat this until the <code>NextToken</code> response element comes back as <code>null</code>.
     * </p>
     * 
     * @return If present, indicates that more output is available than is included in the current response. Use this
     *         value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
     *         next part of the output. You should repeat this until the <code>NextToken</code> response element comes
     *         back as <code>null</code>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledServicePrincipals() ? enabledServicePrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAwsServiceAccessForOrganizationResponse)) {
            return false;
        }
        ListAwsServiceAccessForOrganizationResponse other = (ListAwsServiceAccessForOrganizationResponse) obj;
        return hasEnabledServicePrincipals() == other.hasEnabledServicePrincipals()
                && Objects.equals(enabledServicePrincipals(), other.enabledServicePrincipals())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAwsServiceAccessForOrganizationResponse")
                .add("EnabledServicePrincipals", hasEnabledServicePrincipals() ? enabledServicePrincipals() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnabledServicePrincipals":
            return Optional.ofNullable(clazz.cast(enabledServicePrincipals()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAwsServiceAccessForOrganizationResponse, T> g) {
        return obj -> g.apply((ListAwsServiceAccessForOrganizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OrganizationsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAwsServiceAccessForOrganizationResponse> {
        /**
         * <p>
         * A list of the service principals for the services that are enabled to integrate with your organization. Each
         * principal is a structure that includes the name and the date that it was enabled for integration with
         * Organizations.
         * </p>
         * 
         * @param enabledServicePrincipals
         *        A list of the service principals for the services that are enabled to integrate with your
         *        organization. Each principal is a structure that includes the name and the date that it was enabled
         *        for integration with Organizations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledServicePrincipals(Collection<EnabledServicePrincipal> enabledServicePrincipals);

        /**
         * <p>
         * A list of the service principals for the services that are enabled to integrate with your organization. Each
         * principal is a structure that includes the name and the date that it was enabled for integration with
         * Organizations.
         * </p>
         * 
         * @param enabledServicePrincipals
         *        A list of the service principals for the services that are enabled to integrate with your
         *        organization. Each principal is a structure that includes the name and the date that it was enabled
         *        for integration with Organizations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledServicePrincipals(EnabledServicePrincipal... enabledServicePrincipals);

        /**
         * <p>
         * A list of the service principals for the services that are enabled to integrate with your organization. Each
         * principal is a structure that includes the name and the date that it was enabled for integration with
         * Organizations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.organizations.model.EnabledServicePrincipal.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.organizations.model.EnabledServicePrincipal#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.organizations.model.EnabledServicePrincipal.Builder#build()} is called
         * immediately and its result is passed to {@link #enabledServicePrincipals(List<EnabledServicePrincipal>)}.
         * 
         * @param enabledServicePrincipals
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.organizations.model.EnabledServicePrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #enabledServicePrincipals(java.util.Collection<EnabledServicePrincipal>)
         */
        Builder enabledServicePrincipals(Consumer<EnabledServicePrincipal.Builder>... enabledServicePrincipals);

        /**
         * <p>
         * If present, indicates that more output is available than is included in the current response. Use this value
         * in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the next part of
         * the output. You should repeat this until the <code>NextToken</code> response element comes back as
         * <code>null</code>.
         * </p>
         * 
         * @param nextToken
         *        If present, indicates that more output is available than is included in the current response. Use this
         *        value in the <code>NextToken</code> request parameter in a subsequent call to the operation to get the
         *        next part of the output. You should repeat this until the <code>NextToken</code> response element
         *        comes back as <code>null</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OrganizationsResponse.BuilderImpl implements Builder {
        private List<EnabledServicePrincipal> enabledServicePrincipals = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAwsServiceAccessForOrganizationResponse model) {
            super(model);
            enabledServicePrincipals(model.enabledServicePrincipals);
            nextToken(model.nextToken);
        }

        public final List<EnabledServicePrincipal.Builder> getEnabledServicePrincipals() {
            List<EnabledServicePrincipal.Builder> result = EnabledServicePrincipalsCopier
                    .copyToBuilder(this.enabledServicePrincipals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnabledServicePrincipals(Collection<EnabledServicePrincipal.BuilderImpl> enabledServicePrincipals) {
            this.enabledServicePrincipals = EnabledServicePrincipalsCopier.copyFromBuilder(enabledServicePrincipals);
        }

        @Override
        public final Builder enabledServicePrincipals(Collection<EnabledServicePrincipal> enabledServicePrincipals) {
            this.enabledServicePrincipals = EnabledServicePrincipalsCopier.copy(enabledServicePrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledServicePrincipals(EnabledServicePrincipal... enabledServicePrincipals) {
            enabledServicePrincipals(Arrays.asList(enabledServicePrincipals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledServicePrincipals(Consumer<EnabledServicePrincipal.Builder>... enabledServicePrincipals) {
            enabledServicePrincipals(Stream.of(enabledServicePrincipals)
                    .map(c -> EnabledServicePrincipal.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAwsServiceAccessForOrganizationResponse build() {
            return new ListAwsServiceAccessForOrganizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
