/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.organizations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.organizations.OrganizationsAsyncClient;
import software.amazon.awssdk.services.organizations.model.DelegatedAdministrator;
import software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsRequest;
import software.amazon.awssdk.services.organizations.model.ListDelegatedAdministratorsResponse;

public class ListDelegatedAdministratorsPublisher
implements SdkPublisher<ListDelegatedAdministratorsResponse> {
    private final OrganizationsAsyncClient client;
    private final ListDelegatedAdministratorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListDelegatedAdministratorsPublisher(OrganizationsAsyncClient client, ListDelegatedAdministratorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListDelegatedAdministratorsPublisher(OrganizationsAsyncClient client, ListDelegatedAdministratorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListDelegatedAdministratorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListDelegatedAdministratorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DelegatedAdministrator> delegatedAdministrators() {
        Function<ListDelegatedAdministratorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.delegatedAdministrators() != null) {
                return response.delegatedAdministrators().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListDelegatedAdministratorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListDelegatedAdministratorsResponseFetcher
    implements AsyncPageFetcher<ListDelegatedAdministratorsResponse> {
        private ListDelegatedAdministratorsResponseFetcher() {
        }

        public boolean hasNextPage(ListDelegatedAdministratorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListDelegatedAdministratorsResponse> nextPage(ListDelegatedAdministratorsResponse previousPage) {
            if (previousPage == null) {
                return ListDelegatedAdministratorsPublisher.this.client.listDelegatedAdministrators(ListDelegatedAdministratorsPublisher.this.firstRequest);
            }
            return ListDelegatedAdministratorsPublisher.this.client.listDelegatedAdministrators((ListDelegatedAdministratorsRequest)((Object)ListDelegatedAdministratorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

