/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworkscm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventsResponse extends OpsWorksCmResponse implements
        ToCopyableBuilder<DescribeEventsResponse.Builder, DescribeEventsResponse> {
    private static final SdkField<List<ServerEvent>> SERVER_EVENTS_FIELD = SdkField
            .<List<ServerEvent>> builder(MarshallingType.LIST)
            .memberName("ServerEvents")
            .getter(getter(DescribeEventsResponse::serverEvents))
            .setter(setter(Builder::serverEvents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServerEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServerEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeEventsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_EVENTS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ServerEvent> serverEvents;

    private final String nextToken;

    private DescribeEventsResponse(BuilderImpl builder) {
        super(builder);
        this.serverEvents = builder.serverEvents;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServerEvents property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServerEvents() {
        return serverEvents != null && !(serverEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains the response to a <code>DescribeEvents</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServerEvents} method.
     * </p>
     * 
     * @return Contains the response to a <code>DescribeEvents</code> request.
     */
    public final List<ServerEvent> serverEvents() {
        return serverEvents;
    }

    /**
     * <p>
     * NextToken is a string that is returned in some command responses. It indicates that not all entries have been
     * returned, and that you must run at least one more request to get remaining items. To get remaining results, call
     * <code>DescribeEvents</code> again, and assign the token from the previous results as the value of the
     * <code>nextToken</code> parameter. If there are no more results, the response object's <code>nextToken</code>
     * parameter value is <code>null</code>. Setting a <code>nextToken</code> value that was not returned in your
     * previous results causes an <code>InvalidNextTokenException</code> to occur.
     * </p>
     * 
     * @return NextToken is a string that is returned in some command responses. It indicates that not all entries have
     *         been returned, and that you must run at least one more request to get remaining items. To get remaining
     *         results, call <code>DescribeEvents</code> again, and assign the token from the previous results as the
     *         value of the <code>nextToken</code> parameter. If there are no more results, the response object's
     *         <code>nextToken</code> parameter value is <code>null</code>. Setting a <code>nextToken</code> value that
     *         was not returned in your previous results causes an <code>InvalidNextTokenException</code> to occur.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasServerEvents() ? serverEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventsResponse)) {
            return false;
        }
        DescribeEventsResponse other = (DescribeEventsResponse) obj;
        return hasServerEvents() == other.hasServerEvents() && Objects.equals(serverEvents(), other.serverEvents())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEventsResponse").add("ServerEvents", hasServerEvents() ? serverEvents() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerEvents":
            return Optional.ofNullable(clazz.cast(serverEvents()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventsResponse, T> g) {
        return obj -> g.apply((DescribeEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksCmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeEventsResponse> {
        /**
         * <p>
         * Contains the response to a <code>DescribeEvents</code> request.
         * </p>
         * 
         * @param serverEvents
         *        Contains the response to a <code>DescribeEvents</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverEvents(Collection<ServerEvent> serverEvents);

        /**
         * <p>
         * Contains the response to a <code>DescribeEvents</code> request.
         * </p>
         * 
         * @param serverEvents
         *        Contains the response to a <code>DescribeEvents</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverEvents(ServerEvent... serverEvents);

        /**
         * <p>
         * Contains the response to a <code>DescribeEvents</code> request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opsworkscm.model.ServerEvent.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.opsworkscm.model.ServerEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opsworkscm.model.ServerEvent.Builder#build()} is called immediately
         * and its result is passed to {@link #serverEvents(List<ServerEvent>)}.
         * 
         * @param serverEvents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opsworkscm.model.ServerEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverEvents(java.util.Collection<ServerEvent>)
         */
        Builder serverEvents(Consumer<ServerEvent.Builder>... serverEvents);

        /**
         * <p>
         * NextToken is a string that is returned in some command responses. It indicates that not all entries have been
         * returned, and that you must run at least one more request to get remaining items. To get remaining results,
         * call <code>DescribeEvents</code> again, and assign the token from the previous results as the value of the
         * <code>nextToken</code> parameter. If there are no more results, the response object's <code>nextToken</code>
         * parameter value is <code>null</code>. Setting a <code>nextToken</code> value that was not returned in your
         * previous results causes an <code>InvalidNextTokenException</code> to occur.
         * </p>
         * 
         * @param nextToken
         *        NextToken is a string that is returned in some command responses. It indicates that not all entries
         *        have been returned, and that you must run at least one more request to get remaining items. To get
         *        remaining results, call <code>DescribeEvents</code> again, and assign the token from the previous
         *        results as the value of the <code>nextToken</code> parameter. If there are no more results, the
         *        response object's <code>nextToken</code> parameter value is <code>null</code>. Setting a
         *        <code>nextToken</code> value that was not returned in your previous results causes an
         *        <code>InvalidNextTokenException</code> to occur.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OpsWorksCmResponse.BuilderImpl implements Builder {
        private List<ServerEvent> serverEvents = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventsResponse model) {
            super(model);
            serverEvents(model.serverEvents);
            nextToken(model.nextToken);
        }

        public final List<ServerEvent.Builder> getServerEvents() {
            List<ServerEvent.Builder> result = ServerEventsCopier.copyToBuilder(this.serverEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServerEvents(Collection<ServerEvent.BuilderImpl> serverEvents) {
            this.serverEvents = ServerEventsCopier.copyFromBuilder(serverEvents);
        }

        @Override
        public final Builder serverEvents(Collection<ServerEvent> serverEvents) {
            this.serverEvents = ServerEventsCopier.copy(serverEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverEvents(ServerEvent... serverEvents) {
            serverEvents(Arrays.asList(serverEvents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serverEvents(Consumer<ServerEvent.Builder>... serverEvents) {
            serverEvents(Stream.of(serverEvents).map(c -> ServerEvent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeEventsResponse build() {
            return new DescribeEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
