/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opsworkscm.OpsWorksCmClient;
import software.amazon.awssdk.services.opsworkscm.internal.UserAgentUtils;
import software.amazon.awssdk.services.opsworkscm.model.Backup;
import software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsRequest;
import software.amazon.awssdk.services.opsworkscm.model.DescribeBackupsResponse;

public class DescribeBackupsIterable
implements SdkIterable<DescribeBackupsResponse> {
    private final OpsWorksCmClient client;
    private final DescribeBackupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeBackupsIterable(OpsWorksCmClient client, DescribeBackupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeBackupsResponseFetcher();
    }

    public Iterator<DescribeBackupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Backup> backups() {
        Function<DescribeBackupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.backups() != null) {
                return response.backups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeBackupsResponseFetcher
    implements SyncPageFetcher<DescribeBackupsResponse> {
        private DescribeBackupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBackupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeBackupsResponse nextPage(DescribeBackupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeBackupsIterable.this.client.describeBackups(DescribeBackupsIterable.this.firstRequest);
            }
            return DescribeBackupsIterable.this.client.describeBackups((DescribeBackupsRequest)((Object)DescribeBackupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

