/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearchserverless.OpenSearchServerlessAsyncClient;
import software.amazon.awssdk.services.opensearchserverless.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesResponse;

public class ListAccessPoliciesPublisher
implements SdkPublisher<ListAccessPoliciesResponse> {
    private final OpenSearchServerlessAsyncClient client;
    private final ListAccessPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessPoliciesPublisher(OpenSearchServerlessAsyncClient client, ListAccessPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessPoliciesPublisher(OpenSearchServerlessAsyncClient client, ListAccessPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListAccessPoliciesResponseFetcher
    implements AsyncPageFetcher<ListAccessPoliciesResponse> {
        private ListAccessPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccessPoliciesResponse> nextPage(ListAccessPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAccessPoliciesPublisher.this.client.listAccessPolicies(ListAccessPoliciesPublisher.this.firstRequest);
            }
            return ListAccessPoliciesPublisher.this.client.listAccessPolicies((ListAccessPoliciesRequest)((Object)ListAccessPoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

