/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetLifecyclePolicyResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<BatchGetLifecyclePolicyResponse.Builder, BatchGetLifecyclePolicyResponse> {
    private static final SdkField<List<LifecyclePolicyDetail>> LIFECYCLE_POLICY_DETAILS_FIELD = SdkField
            .<List<LifecyclePolicyDetail>> builder(MarshallingType.LIST)
            .memberName("lifecyclePolicyDetails")
            .getter(getter(BatchGetLifecyclePolicyResponse::lifecyclePolicyDetails))
            .setter(setter(Builder::lifecyclePolicyDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicyDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LifecyclePolicyDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(LifecyclePolicyDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<LifecyclePolicyErrorDetail>> LIFECYCLE_POLICY_ERROR_DETAILS_FIELD = SdkField
            .<List<LifecyclePolicyErrorDetail>> builder(MarshallingType.LIST)
            .memberName("lifecyclePolicyErrorDetails")
            .getter(getter(BatchGetLifecyclePolicyResponse::lifecyclePolicyErrorDetails))
            .setter(setter(Builder::lifecyclePolicyErrorDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicyErrorDetails")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LifecyclePolicyErrorDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(LifecyclePolicyErrorDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LIFECYCLE_POLICY_DETAILS_FIELD, LIFECYCLE_POLICY_ERROR_DETAILS_FIELD));

    private final List<LifecyclePolicyDetail> lifecyclePolicyDetails;

    private final List<LifecyclePolicyErrorDetail> lifecyclePolicyErrorDetails;

    private BatchGetLifecyclePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.lifecyclePolicyDetails = builder.lifecyclePolicyDetails;
        this.lifecyclePolicyErrorDetails = builder.lifecyclePolicyErrorDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the LifecyclePolicyDetails property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLifecyclePolicyDetails() {
        return lifecyclePolicyDetails != null && !(lifecyclePolicyDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of lifecycle policies matched to the input policy name and policy type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLifecyclePolicyDetails} method.
     * </p>
     * 
     * @return A list of lifecycle policies matched to the input policy name and policy type.
     */
    public final List<LifecyclePolicyDetail> lifecyclePolicyDetails() {
        return lifecyclePolicyDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the LifecyclePolicyErrorDetails property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLifecyclePolicyErrorDetails() {
        return lifecyclePolicyErrorDetails != null && !(lifecyclePolicyErrorDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of lifecycle policy names and policy types for which retrieval failed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLifecyclePolicyErrorDetails} method.
     * </p>
     * 
     * @return A list of lifecycle policy names and policy types for which retrieval failed.
     */
    public final List<LifecyclePolicyErrorDetail> lifecyclePolicyErrorDetails() {
        return lifecyclePolicyErrorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLifecyclePolicyDetails() ? lifecyclePolicyDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLifecyclePolicyErrorDetails() ? lifecyclePolicyErrorDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetLifecyclePolicyResponse)) {
            return false;
        }
        BatchGetLifecyclePolicyResponse other = (BatchGetLifecyclePolicyResponse) obj;
        return hasLifecyclePolicyDetails() == other.hasLifecyclePolicyDetails()
                && Objects.equals(lifecyclePolicyDetails(), other.lifecyclePolicyDetails())
                && hasLifecyclePolicyErrorDetails() == other.hasLifecyclePolicyErrorDetails()
                && Objects.equals(lifecyclePolicyErrorDetails(), other.lifecyclePolicyErrorDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetLifecyclePolicyResponse")
                .add("LifecyclePolicyDetails", hasLifecyclePolicyDetails() ? lifecyclePolicyDetails() : null)
                .add("LifecyclePolicyErrorDetails", hasLifecyclePolicyErrorDetails() ? lifecyclePolicyErrorDetails() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lifecyclePolicyDetails":
            return Optional.ofNullable(clazz.cast(lifecyclePolicyDetails()));
        case "lifecyclePolicyErrorDetails":
            return Optional.ofNullable(clazz.cast(lifecyclePolicyErrorDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetLifecyclePolicyResponse, T> g) {
        return obj -> g.apply((BatchGetLifecyclePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetLifecyclePolicyResponse> {
        /**
         * <p>
         * A list of lifecycle policies matched to the input policy name and policy type.
         * </p>
         * 
         * @param lifecyclePolicyDetails
         *        A list of lifecycle policies matched to the input policy name and policy type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicyDetails(Collection<LifecyclePolicyDetail> lifecyclePolicyDetails);

        /**
         * <p>
         * A list of lifecycle policies matched to the input policy name and policy type.
         * </p>
         * 
         * @param lifecyclePolicyDetails
         *        A list of lifecycle policies matched to the input policy name and policy type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicyDetails(LifecyclePolicyDetail... lifecyclePolicyDetails);

        /**
         * <p>
         * A list of lifecycle policies matched to the input policy name and policy type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyDetail.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyDetail.Builder#build()} is
         * called immediately and its result is passed to {@link #lifecyclePolicyDetails(List<LifecyclePolicyDetail>)}.
         * 
         * @param lifecyclePolicyDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecyclePolicyDetails(java.util.Collection<LifecyclePolicyDetail>)
         */
        Builder lifecyclePolicyDetails(Consumer<LifecyclePolicyDetail.Builder>... lifecyclePolicyDetails);

        /**
         * <p>
         * A list of lifecycle policy names and policy types for which retrieval failed.
         * </p>
         * 
         * @param lifecyclePolicyErrorDetails
         *        A list of lifecycle policy names and policy types for which retrieval failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicyErrorDetails(Collection<LifecyclePolicyErrorDetail> lifecyclePolicyErrorDetails);

        /**
         * <p>
         * A list of lifecycle policy names and policy types for which retrieval failed.
         * </p>
         * 
         * @param lifecyclePolicyErrorDetails
         *        A list of lifecycle policy names and policy types for which retrieval failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicyErrorDetails(LifecyclePolicyErrorDetail... lifecyclePolicyErrorDetails);

        /**
         * <p>
         * A list of lifecycle policy names and policy types for which retrieval failed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyErrorDetail.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyErrorDetail.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #lifecyclePolicyErrorDetails(List<LifecyclePolicyErrorDetail>)}.
         * 
         * @param lifecyclePolicyErrorDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecyclePolicyErrorDetails(java.util.Collection<LifecyclePolicyErrorDetail>)
         */
        Builder lifecyclePolicyErrorDetails(Consumer<LifecyclePolicyErrorDetail.Builder>... lifecyclePolicyErrorDetails);
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private List<LifecyclePolicyDetail> lifecyclePolicyDetails = DefaultSdkAutoConstructList.getInstance();

        private List<LifecyclePolicyErrorDetail> lifecyclePolicyErrorDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetLifecyclePolicyResponse model) {
            super(model);
            lifecyclePolicyDetails(model.lifecyclePolicyDetails);
            lifecyclePolicyErrorDetails(model.lifecyclePolicyErrorDetails);
        }

        public final List<LifecyclePolicyDetail.Builder> getLifecyclePolicyDetails() {
            List<LifecyclePolicyDetail.Builder> result = LifecyclePolicyDetailsCopier.copyToBuilder(this.lifecyclePolicyDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLifecyclePolicyDetails(Collection<LifecyclePolicyDetail.BuilderImpl> lifecyclePolicyDetails) {
            this.lifecyclePolicyDetails = LifecyclePolicyDetailsCopier.copyFromBuilder(lifecyclePolicyDetails);
        }

        @Override
        public final Builder lifecyclePolicyDetails(Collection<LifecyclePolicyDetail> lifecyclePolicyDetails) {
            this.lifecyclePolicyDetails = LifecyclePolicyDetailsCopier.copy(lifecyclePolicyDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicyDetails(LifecyclePolicyDetail... lifecyclePolicyDetails) {
            lifecyclePolicyDetails(Arrays.asList(lifecyclePolicyDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicyDetails(Consumer<LifecyclePolicyDetail.Builder>... lifecyclePolicyDetails) {
            lifecyclePolicyDetails(Stream.of(lifecyclePolicyDetails)
                    .map(c -> LifecyclePolicyDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LifecyclePolicyErrorDetail.Builder> getLifecyclePolicyErrorDetails() {
            List<LifecyclePolicyErrorDetail.Builder> result = LifecyclePolicyErrorDetailsCopier
                    .copyToBuilder(this.lifecyclePolicyErrorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLifecyclePolicyErrorDetails(
                Collection<LifecyclePolicyErrorDetail.BuilderImpl> lifecyclePolicyErrorDetails) {
            this.lifecyclePolicyErrorDetails = LifecyclePolicyErrorDetailsCopier.copyFromBuilder(lifecyclePolicyErrorDetails);
        }

        @Override
        public final Builder lifecyclePolicyErrorDetails(Collection<LifecyclePolicyErrorDetail> lifecyclePolicyErrorDetails) {
            this.lifecyclePolicyErrorDetails = LifecyclePolicyErrorDetailsCopier.copy(lifecyclePolicyErrorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicyErrorDetails(LifecyclePolicyErrorDetail... lifecyclePolicyErrorDetails) {
            lifecyclePolicyErrorDetails(Arrays.asList(lifecyclePolicyErrorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicyErrorDetails(
                Consumer<LifecyclePolicyErrorDetail.Builder>... lifecyclePolicyErrorDetails) {
            lifecyclePolicyErrorDetails(Stream.of(lifecyclePolicyErrorDetails)
                    .map(c -> LifecyclePolicyErrorDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetLifecyclePolicyResponse build() {
            return new BatchGetLifecyclePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
