/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessRequest;
import software.amazon.awssdk.services.opensearchserverless.model.SamlConfigOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSecurityConfigRequest
extends OpenSearchServerlessRequest
implements ToCopyableBuilder<Builder, UpdateSecurityConfigRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateSecurityConfigRequest.getter(UpdateSecurityConfigRequest::clientToken)).setter(UpdateSecurityConfigRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> CONFIG_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configVersion").getter(UpdateSecurityConfigRequest.getter(UpdateSecurityConfigRequest::configVersion)).setter(UpdateSecurityConfigRequest.setter(Builder::configVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateSecurityConfigRequest.getter(UpdateSecurityConfigRequest::description)).setter(UpdateSecurityConfigRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateSecurityConfigRequest.getter(UpdateSecurityConfigRequest::id)).setter(UpdateSecurityConfigRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<SamlConfigOptions> SAML_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("samlOptions").getter(UpdateSecurityConfigRequest.getter(UpdateSecurityConfigRequest::samlOptions)).setter(UpdateSecurityConfigRequest.setter(Builder::samlOptions)).constructor(SamlConfigOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, CONFIG_VERSION_FIELD, DESCRIPTION_FIELD, ID_FIELD, SAML_OPTIONS_FIELD));
    private final String clientToken;
    private final String configVersion;
    private final String description;
    private final String id;
    private final SamlConfigOptions samlOptions;

    private UpdateSecurityConfigRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.configVersion = builder.configVersion;
        this.description = builder.description;
        this.id = builder.id;
        this.samlOptions = builder.samlOptions;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String configVersion() {
        return this.configVersion;
    }

    public final String description() {
        return this.description;
    }

    public final String id() {
        return this.id;
    }

    public final SamlConfigOptions samlOptions() {
        return this.samlOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.configVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.samlOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityConfigRequest)) {
            return false;
        }
        UpdateSecurityConfigRequest other = (UpdateSecurityConfigRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.configVersion(), other.configVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.samlOptions(), other.samlOptions());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSecurityConfigRequest").add("ClientToken", (Object)this.clientToken()).add("ConfigVersion", (Object)this.configVersion()).add("Description", (Object)this.description()).add("Id", (Object)this.id()).add("SamlOptions", (Object)this.samlOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "configVersion": {
                return Optional.ofNullable(clazz.cast(this.configVersion()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "samlOptions": {
                return Optional.ofNullable(clazz.cast(this.samlOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityConfigRequest, T> g) {
        return obj -> g.apply((UpdateSecurityConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchServerlessRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String configVersion;
        private String description;
        private String id;
        private SamlConfigOptions samlOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityConfigRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.configVersion(model.configVersion);
            this.description(model.description);
            this.id(model.id);
            this.samlOptions(model.samlOptions);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getConfigVersion() {
            return this.configVersion;
        }

        public final void setConfigVersion(String configVersion) {
            this.configVersion = configVersion;
        }

        @Override
        public final Builder configVersion(String configVersion) {
            this.configVersion = configVersion;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final SamlConfigOptions.Builder getSamlOptions() {
            return this.samlOptions != null ? this.samlOptions.toBuilder() : null;
        }

        public final void setSamlOptions(SamlConfigOptions.BuilderImpl samlOptions) {
            this.samlOptions = samlOptions != null ? samlOptions.build() : null;
        }

        @Override
        public final Builder samlOptions(SamlConfigOptions samlOptions) {
            this.samlOptions = samlOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityConfigRequest build() {
            return new UpdateSecurityConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpenSearchServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSecurityConfigRequest> {
        public Builder clientToken(String var1);

        public Builder configVersion(String var1);

        public Builder description(String var1);

        public Builder id(String var1);

        public Builder samlOptions(SamlConfigOptions var1);

        default public Builder samlOptions(Consumer<SamlConfigOptions.Builder> samlOptions) {
            return this.samlOptions((SamlConfigOptions)((SamlConfigOptions.Builder)SamlConfigOptions.builder().applyMutation(samlOptions)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

