/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicySummariesCopier;
import software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicySummary;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLifecyclePoliciesResponse
extends OpenSearchServerlessResponse
implements ToCopyableBuilder<Builder, ListLifecyclePoliciesResponse> {
    private static final SdkField<List<LifecyclePolicySummary>> LIFECYCLE_POLICY_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lifecyclePolicySummaries").getter(ListLifecyclePoliciesResponse.getter(ListLifecyclePoliciesResponse::lifecyclePolicySummaries)).setter(ListLifecyclePoliciesResponse.setter(Builder::lifecyclePolicySummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicySummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecyclePolicySummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListLifecyclePoliciesResponse.getter(ListLifecyclePoliciesResponse::nextToken)).setter(ListLifecyclePoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_POLICY_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<LifecyclePolicySummary> lifecyclePolicySummaries;
    private final String nextToken;

    private ListLifecyclePoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.lifecyclePolicySummaries = builder.lifecyclePolicySummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLifecyclePolicySummaries() {
        return this.lifecyclePolicySummaries != null && !(this.lifecyclePolicySummaries instanceof SdkAutoConstructList);
    }

    public final List<LifecyclePolicySummary> lifecyclePolicySummaries() {
        return this.lifecyclePolicySummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLifecyclePolicySummaries() ? this.lifecyclePolicySummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLifecyclePoliciesResponse)) {
            return false;
        }
        ListLifecyclePoliciesResponse other = (ListLifecyclePoliciesResponse)((Object)obj);
        return this.hasLifecyclePolicySummaries() == other.hasLifecyclePolicySummaries() && Objects.equals(this.lifecyclePolicySummaries(), other.lifecyclePolicySummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLifecyclePoliciesResponse").add("LifecyclePolicySummaries", this.hasLifecyclePolicySummaries() ? this.lifecyclePolicySummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lifecyclePolicySummaries": {
                return Optional.ofNullable(clazz.cast(this.lifecyclePolicySummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLifecyclePoliciesResponse, T> g) {
        return obj -> g.apply((ListLifecyclePoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchServerlessResponse.BuilderImpl
    implements Builder {
        private List<LifecyclePolicySummary> lifecyclePolicySummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLifecyclePoliciesResponse model) {
            super(model);
            this.lifecyclePolicySummaries(model.lifecyclePolicySummaries);
            this.nextToken(model.nextToken);
        }

        public final List<LifecyclePolicySummary.Builder> getLifecyclePolicySummaries() {
            List<LifecyclePolicySummary.Builder> result = LifecyclePolicySummariesCopier.copyToBuilder(this.lifecyclePolicySummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLifecyclePolicySummaries(Collection<LifecyclePolicySummary.BuilderImpl> lifecyclePolicySummaries) {
            this.lifecyclePolicySummaries = LifecyclePolicySummariesCopier.copyFromBuilder(lifecyclePolicySummaries);
        }

        @Override
        public final Builder lifecyclePolicySummaries(Collection<LifecyclePolicySummary> lifecyclePolicySummaries) {
            this.lifecyclePolicySummaries = LifecyclePolicySummariesCopier.copy(lifecyclePolicySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicySummaries(LifecyclePolicySummary ... lifecyclePolicySummaries) {
            this.lifecyclePolicySummaries(Arrays.asList(lifecyclePolicySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecyclePolicySummaries(Consumer<LifecyclePolicySummary.Builder> ... lifecyclePolicySummaries) {
            this.lifecyclePolicySummaries(Stream.of(lifecyclePolicySummaries).map(c -> (LifecyclePolicySummary)((LifecyclePolicySummary.Builder)LifecyclePolicySummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLifecyclePoliciesResponse build() {
            return new ListLifecyclePoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpenSearchServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLifecyclePoliciesResponse> {
        public Builder lifecyclePolicySummaries(Collection<LifecyclePolicySummary> var1);

        public Builder lifecyclePolicySummaries(LifecyclePolicySummary ... var1);

        public Builder lifecyclePolicySummaries(Consumer<LifecyclePolicySummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

