/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Statistics for an OpenSearch Serverless security configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityConfigStats implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityConfigStats.Builder, SecurityConfigStats> {
    private static final SdkField<Long> SAML_CONFIG_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SamlConfigCount").getter(getter(SecurityConfigStats::samlConfigCount))
            .setter(setter(Builder::samlConfigCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamlConfigCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_CONFIG_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long samlConfigCount;

    private SecurityConfigStats(BuilderImpl builder) {
        this.samlConfigCount = builder.samlConfigCount;
    }

    /**
     * <p>
     * The number of security configurations in the current account.
     * </p>
     * 
     * @return The number of security configurations in the current account.
     */
    public final Long samlConfigCount() {
        return samlConfigCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(samlConfigCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityConfigStats)) {
            return false;
        }
        SecurityConfigStats other = (SecurityConfigStats) obj;
        return Objects.equals(samlConfigCount(), other.samlConfigCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityConfigStats").add("SamlConfigCount", samlConfigCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SamlConfigCount":
            return Optional.ofNullable(clazz.cast(samlConfigCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SecurityConfigStats, T> g) {
        return obj -> g.apply((SecurityConfigStats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityConfigStats> {
        /**
         * <p>
         * The number of security configurations in the current account.
         * </p>
         * 
         * @param samlConfigCount
         *        The number of security configurations in the current account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlConfigCount(Long samlConfigCount);
    }

    static final class BuilderImpl implements Builder {
        private Long samlConfigCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityConfigStats model) {
            samlConfigCount(model.samlConfigCount);
        }

        public final Long getSamlConfigCount() {
            return samlConfigCount;
        }

        public final void setSamlConfigCount(Long samlConfigCount) {
            this.samlConfigCount = samlConfigCount;
        }

        @Override
        public final Builder samlConfigCount(Long samlConfigCount) {
            this.samlConfigCount = samlConfigCount;
            return this;
        }

        @Override
        public SecurityConfigStats build() {
            return new SecurityConfigStats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
