/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Error information for an OpenSearch Serverless request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EffectiveLifecyclePolicyDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<EffectiveLifecyclePolicyDetail.Builder, EffectiveLifecyclePolicyDetail> {
    private static final SdkField<Boolean> NO_MIN_RETENTION_PERIOD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("noMinRetentionPeriod").getter(getter(EffectiveLifecyclePolicyDetail::noMinRetentionPeriod))
            .setter(setter(Builder::noMinRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noMinRetentionPeriod").build())
            .build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyName").getter(getter(EffectiveLifecyclePolicyDetail::policyName))
            .setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyName").build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resource").getter(getter(EffectiveLifecyclePolicyDetail::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(EffectiveLifecyclePolicyDetail::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> RETENTION_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("retentionPeriod").getter(getter(EffectiveLifecyclePolicyDetail::retentionPeriod))
            .setter(setter(Builder::retentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionPeriod").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(EffectiveLifecyclePolicyDetail::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NO_MIN_RETENTION_PERIOD_FIELD,
            POLICY_NAME_FIELD, RESOURCE_FIELD, RESOURCE_TYPE_FIELD, RETENTION_PERIOD_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean noMinRetentionPeriod;

    private final String policyName;

    private final String resource;

    private final String resourceType;

    private final String retentionPeriod;

    private final String type;

    private EffectiveLifecyclePolicyDetail(BuilderImpl builder) {
        this.noMinRetentionPeriod = builder.noMinRetentionPeriod;
        this.policyName = builder.policyName;
        this.resource = builder.resource;
        this.resourceType = builder.resourceType;
        this.retentionPeriod = builder.retentionPeriod;
        this.type = builder.type;
    }

    /**
     * <p>
     * The minimum number of index retention days set. That is an optional param that will return as <code>true</code>
     * if the minimum number of days or hours is not set to a index resource.
     * </p>
     * 
     * @return The minimum number of index retention days set. That is an optional param that will return as
     *         <code>true</code> if the minimum number of days or hours is not set to a index resource.
     */
    public final Boolean noMinRetentionPeriod() {
        return noMinRetentionPeriod;
    }

    /**
     * <p>
     * The name of the lifecycle policy.
     * </p>
     * 
     * @return The name of the lifecycle policy.
     */
    public final String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The name of the OpenSearch Serverless index resource.
     * </p>
     * 
     * @return The name of the OpenSearch Serverless index resource.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * The type of OpenSearch Serverless resource. Currently, the only supported resource is <code>index</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of OpenSearch Serverless resource. Currently, the only supported resource is <code>index</code>.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of OpenSearch Serverless resource. Currently, the only supported resource is <code>index</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of OpenSearch Serverless resource. Currently, the only supported resource is <code>index</code>.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The minimum number of index retention in days or hours. This is an optional parameter that will return only if
     * it’s set.
     * </p>
     * 
     * @return The minimum number of index retention in days or hours. This is an optional parameter that will return
     *         only if it’s set.
     */
    public final String retentionPeriod() {
        return retentionPeriod;
    }

    /**
     * <p>
     * The type of lifecycle policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LifecyclePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of lifecycle policy.
     * @see LifecyclePolicyType
     */
    public final LifecyclePolicyType type() {
        return LifecyclePolicyType.fromValue(type);
    }

    /**
     * <p>
     * The type of lifecycle policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LifecyclePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of lifecycle policy.
     * @see LifecyclePolicyType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(noMinRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectiveLifecyclePolicyDetail)) {
            return false;
        }
        EffectiveLifecyclePolicyDetail other = (EffectiveLifecyclePolicyDetail) obj;
        return Objects.equals(noMinRetentionPeriod(), other.noMinRetentionPeriod())
                && Objects.equals(policyName(), other.policyName()) && Objects.equals(resource(), other.resource())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(retentionPeriod(), other.retentionPeriod())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EffectiveLifecyclePolicyDetail").add("NoMinRetentionPeriod", noMinRetentionPeriod())
                .add("PolicyName", policyName()).add("Resource", resource()).add("ResourceType", resourceTypeAsString())
                .add("RetentionPeriod", retentionPeriod()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "noMinRetentionPeriod":
            return Optional.ofNullable(clazz.cast(noMinRetentionPeriod()));
        case "policyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "retentionPeriod":
            return Optional.ofNullable(clazz.cast(retentionPeriod()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EffectiveLifecyclePolicyDetail, T> g) {
        return obj -> g.apply((EffectiveLifecyclePolicyDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EffectiveLifecyclePolicyDetail> {
        /**
         * <p>
         * The minimum number of index retention days set. That is an optional param that will return as
         * <code>true</code> if the minimum number of days or hours is not set to a index resource.
         * </p>
         * 
         * @param noMinRetentionPeriod
         *        The minimum number of index retention days set. That is an optional param that will return as
         *        <code>true</code> if the minimum number of days or hours is not set to a index resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noMinRetentionPeriod(Boolean noMinRetentionPeriod);

        /**
         * <p>
         * The name of the lifecycle policy.
         * </p>
         * 
         * @param policyName
         *        The name of the lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The name of the OpenSearch Serverless index resource.
         * </p>
         * 
         * @param resource
         *        The name of the OpenSearch Serverless index resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * The type of OpenSearch Serverless resource. Currently, the only supported resource is <code>index</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of OpenSearch Serverless resource. Currently, the only supported resource is
         *        <code>index</code>.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of OpenSearch Serverless resource. Currently, the only supported resource is <code>index</code>.
         * </p>
         * 
         * @param resourceType
         *        The type of OpenSearch Serverless resource. Currently, the only supported resource is
         *        <code>index</code>.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The minimum number of index retention in days or hours. This is an optional parameter that will return only
         * if it’s set.
         * </p>
         * 
         * @param retentionPeriod
         *        The minimum number of index retention in days or hours. This is an optional parameter that will return
         *        only if it’s set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriod(String retentionPeriod);

        /**
         * <p>
         * The type of lifecycle policy.
         * </p>
         * 
         * @param type
         *        The type of lifecycle policy.
         * @see LifecyclePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of lifecycle policy.
         * </p>
         * 
         * @param type
         *        The type of lifecycle policy.
         * @see LifecyclePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyType
         */
        Builder type(LifecyclePolicyType type);
    }

    static final class BuilderImpl implements Builder {
        private Boolean noMinRetentionPeriod;

        private String policyName;

        private String resource;

        private String resourceType;

        private String retentionPeriod;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(EffectiveLifecyclePolicyDetail model) {
            noMinRetentionPeriod(model.noMinRetentionPeriod);
            policyName(model.policyName);
            resource(model.resource);
            resourceType(model.resourceType);
            retentionPeriod(model.retentionPeriod);
            type(model.type);
        }

        public final Boolean getNoMinRetentionPeriod() {
            return noMinRetentionPeriod;
        }

        public final void setNoMinRetentionPeriod(Boolean noMinRetentionPeriod) {
            this.noMinRetentionPeriod = noMinRetentionPeriod;
        }

        @Override
        public final Builder noMinRetentionPeriod(Boolean noMinRetentionPeriod) {
            this.noMinRetentionPeriod = noMinRetentionPeriod;
            return this;
        }

        public final String getPolicyName() {
            return policyName;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getRetentionPeriod() {
            return retentionPeriod;
        }

        public final void setRetentionPeriod(String retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(String retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LifecyclePolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public EffectiveLifecyclePolicyDetail build() {
            return new EffectiveLifecyclePolicyDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
