/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearchserverless.OpenSearchServerlessAsyncClient;
import software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsResponse;

public class ListSecurityConfigsPublisher
implements SdkPublisher<ListSecurityConfigsResponse> {
    private final OpenSearchServerlessAsyncClient client;
    private final ListSecurityConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSecurityConfigsPublisher(OpenSearchServerlessAsyncClient client, ListSecurityConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSecurityConfigsPublisher(OpenSearchServerlessAsyncClient client, ListSecurityConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSecurityConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSecurityConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSecurityConfigsResponseFetcher
    implements AsyncPageFetcher<ListSecurityConfigsResponse> {
        private ListSecurityConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListSecurityConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSecurityConfigsResponse> nextPage(ListSecurityConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListSecurityConfigsPublisher.this.client.listSecurityConfigs(ListSecurityConfigsPublisher.this.firstRequest);
            }
            return ListSecurityConfigsPublisher.this.client.listSecurityConfigs((ListSecurityConfigsRequest)((Object)ListSecurityConfigsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

