/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opensearch.OpenSearchAsyncClient;
import software.amazon.awssdk.services.opensearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsRequest;
import software.amazon.awssdk.services.opensearch.model.DescribeInboundConnectionsResponse;

public class DescribeInboundConnectionsPublisher
implements SdkPublisher<DescribeInboundConnectionsResponse> {
    private final OpenSearchAsyncClient client;
    private final DescribeInboundConnectionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeInboundConnectionsPublisher(OpenSearchAsyncClient client, DescribeInboundConnectionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeInboundConnectionsPublisher(OpenSearchAsyncClient client, DescribeInboundConnectionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeInboundConnectionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeInboundConnectionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeInboundConnectionsResponseFetcher
    implements AsyncPageFetcher<DescribeInboundConnectionsResponse> {
        private DescribeInboundConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInboundConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeInboundConnectionsResponse> nextPage(DescribeInboundConnectionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeInboundConnectionsPublisher.this.client.describeInboundConnections(DescribeInboundConnectionsPublisher.this.firstRequest);
            }
            return DescribeInboundConnectionsPublisher.this.client.describeInboundConnections((DescribeInboundConnectionsRequest)((Object)DescribeInboundConnectionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

