/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.opensearch.model.AdvancedOptionsCopier;
import software.amazon.awssdk.services.opensearch.model.ChangeProgressDetails;
import software.amazon.awssdk.services.opensearch.model.OpenSearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpgradeDomainResponse
extends OpenSearchResponse
implements ToCopyableBuilder<Builder, UpgradeDomainResponse> {
    private static final SdkField<String> UPGRADE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpgradeId").getter(UpgradeDomainResponse.getter(UpgradeDomainResponse::upgradeId)).setter(UpgradeDomainResponse.setter(Builder::upgradeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeId").build()}).build();
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(UpgradeDomainResponse.getter(UpgradeDomainResponse::domainName)).setter(UpgradeDomainResponse.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()}).build();
    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetVersion").getter(UpgradeDomainResponse.getter(UpgradeDomainResponse::targetVersion)).setter(UpgradeDomainResponse.setter(Builder::targetVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVersion").build()}).build();
    private static final SdkField<Boolean> PERFORM_CHECK_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PerformCheckOnly").getter(UpgradeDomainResponse.getter(UpgradeDomainResponse::performCheckOnly)).setter(UpgradeDomainResponse.setter(Builder::performCheckOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformCheckOnly").build()}).build();
    private static final SdkField<Map<String, String>> ADVANCED_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AdvancedOptions").getter(UpgradeDomainResponse.getter(UpgradeDomainResponse::advancedOptions)).setter(UpgradeDomainResponse.setter(Builder::advancedOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdvancedOptions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ChangeProgressDetails> CHANGE_PROGRESS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ChangeProgressDetails").getter(UpgradeDomainResponse.getter(UpgradeDomainResponse::changeProgressDetails)).setter(UpgradeDomainResponse.setter(Builder::changeProgressDetails)).constructor(ChangeProgressDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeProgressDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPGRADE_ID_FIELD, DOMAIN_NAME_FIELD, TARGET_VERSION_FIELD, PERFORM_CHECK_ONLY_FIELD, ADVANCED_OPTIONS_FIELD, CHANGE_PROGRESS_DETAILS_FIELD));
    private final String upgradeId;
    private final String domainName;
    private final String targetVersion;
    private final Boolean performCheckOnly;
    private final Map<String, String> advancedOptions;
    private final ChangeProgressDetails changeProgressDetails;

    private UpgradeDomainResponse(BuilderImpl builder) {
        super(builder);
        this.upgradeId = builder.upgradeId;
        this.domainName = builder.domainName;
        this.targetVersion = builder.targetVersion;
        this.performCheckOnly = builder.performCheckOnly;
        this.advancedOptions = builder.advancedOptions;
        this.changeProgressDetails = builder.changeProgressDetails;
    }

    public final String upgradeId() {
        return this.upgradeId;
    }

    public final String domainName() {
        return this.domainName;
    }

    public final String targetVersion() {
        return this.targetVersion;
    }

    public final Boolean performCheckOnly() {
        return this.performCheckOnly;
    }

    public final boolean hasAdvancedOptions() {
        return this.advancedOptions != null && !(this.advancedOptions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> advancedOptions() {
        return this.advancedOptions;
    }

    public final ChangeProgressDetails changeProgressDetails() {
        return this.changeProgressDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.upgradeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.performCheckOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdvancedOptions() ? this.advancedOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.changeProgressDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeDomainResponse)) {
            return false;
        }
        UpgradeDomainResponse other = (UpgradeDomainResponse)((Object)obj);
        return Objects.equals(this.upgradeId(), other.upgradeId()) && Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.targetVersion(), other.targetVersion()) && Objects.equals(this.performCheckOnly(), other.performCheckOnly()) && this.hasAdvancedOptions() == other.hasAdvancedOptions() && Objects.equals(this.advancedOptions(), other.advancedOptions()) && Objects.equals(this.changeProgressDetails(), other.changeProgressDetails());
    }

    public final String toString() {
        return ToString.builder((String)"UpgradeDomainResponse").add("UpgradeId", (Object)this.upgradeId()).add("DomainName", (Object)this.domainName()).add("TargetVersion", (Object)this.targetVersion()).add("PerformCheckOnly", (Object)this.performCheckOnly()).add("AdvancedOptions", this.hasAdvancedOptions() ? this.advancedOptions() : null).add("ChangeProgressDetails", (Object)this.changeProgressDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UpgradeId": {
                return Optional.ofNullable(clazz.cast(this.upgradeId()));
            }
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "TargetVersion": {
                return Optional.ofNullable(clazz.cast(this.targetVersion()));
            }
            case "PerformCheckOnly": {
                return Optional.ofNullable(clazz.cast(this.performCheckOnly()));
            }
            case "AdvancedOptions": {
                return Optional.ofNullable(clazz.cast(this.advancedOptions()));
            }
            case "ChangeProgressDetails": {
                return Optional.ofNullable(clazz.cast(this.changeProgressDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpgradeDomainResponse, T> g) {
        return obj -> g.apply((UpgradeDomainResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchResponse.BuilderImpl
    implements Builder {
        private String upgradeId;
        private String domainName;
        private String targetVersion;
        private Boolean performCheckOnly;
        private Map<String, String> advancedOptions = DefaultSdkAutoConstructMap.getInstance();
        private ChangeProgressDetails changeProgressDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeDomainResponse model) {
            super(model);
            this.upgradeId(model.upgradeId);
            this.domainName(model.domainName);
            this.targetVersion(model.targetVersion);
            this.performCheckOnly(model.performCheckOnly);
            this.advancedOptions(model.advancedOptions);
            this.changeProgressDetails(model.changeProgressDetails);
        }

        public final String getUpgradeId() {
            return this.upgradeId;
        }

        public final void setUpgradeId(String upgradeId) {
            this.upgradeId = upgradeId;
        }

        @Override
        public final Builder upgradeId(String upgradeId) {
            this.upgradeId = upgradeId;
            return this;
        }

        public final String getDomainName() {
            return this.domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getTargetVersion() {
            return this.targetVersion;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final Boolean getPerformCheckOnly() {
            return this.performCheckOnly;
        }

        public final void setPerformCheckOnly(Boolean performCheckOnly) {
            this.performCheckOnly = performCheckOnly;
        }

        @Override
        public final Builder performCheckOnly(Boolean performCheckOnly) {
            this.performCheckOnly = performCheckOnly;
            return this;
        }

        public final Map<String, String> getAdvancedOptions() {
            if (this.advancedOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.advancedOptions;
        }

        public final void setAdvancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
        }

        @Override
        public final Builder advancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = AdvancedOptionsCopier.copy(advancedOptions);
            return this;
        }

        public final ChangeProgressDetails.Builder getChangeProgressDetails() {
            return this.changeProgressDetails != null ? this.changeProgressDetails.toBuilder() : null;
        }

        public final void setChangeProgressDetails(ChangeProgressDetails.BuilderImpl changeProgressDetails) {
            this.changeProgressDetails = changeProgressDetails != null ? changeProgressDetails.build() : null;
        }

        @Override
        public final Builder changeProgressDetails(ChangeProgressDetails changeProgressDetails) {
            this.changeProgressDetails = changeProgressDetails;
            return this;
        }

        @Override
        public UpgradeDomainResponse build() {
            return new UpgradeDomainResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpenSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpgradeDomainResponse> {
        public Builder upgradeId(String var1);

        public Builder domainName(String var1);

        public Builder targetVersion(String var1);

        public Builder performCheckOnly(Boolean var1);

        public Builder advancedOptions(Map<String, String> var1);

        public Builder changeProgressDetails(ChangeProgressDetails var1);

        default public Builder changeProgressDetails(Consumer<ChangeProgressDetails.Builder> changeProgressDetails) {
            return this.changeProgressDetails((ChangeProgressDetails)((ChangeProgressDetails.Builder)ChangeProgressDetails.builder().applyMutation(changeProgressDetails)).build());
        }
    }
}

