/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PluginProperties
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PluginProperties> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PluginProperties.getter(PluginProperties::name)).setter(PluginProperties.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(PluginProperties.getter(PluginProperties::description)).setter(PluginProperties.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Version").getter(PluginProperties.getter(PluginProperties::version)).setter(PluginProperties.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()}).build();
    private static final SdkField<String> CLASS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClassName").getter(PluginProperties.getter(PluginProperties::className)).setter(PluginProperties.setter(Builder::className)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassName").build()}).build();
    private static final SdkField<Long> UNCOMPRESSED_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("UncompressedSizeInBytes").getter(PluginProperties.getter(PluginProperties::uncompressedSizeInBytes)).setter(PluginProperties.setter(Builder::uncompressedSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UncompressedSizeInBytes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, VERSION_FIELD, CLASS_NAME_FIELD, UNCOMPRESSED_SIZE_IN_BYTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String version;
    private final String className;
    private final Long uncompressedSizeInBytes;

    private PluginProperties(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.version = builder.version;
        this.className = builder.className;
        this.uncompressedSizeInBytes = builder.uncompressedSizeInBytes;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String version() {
        return this.version;
    }

    public final String className() {
        return this.className;
    }

    public final Long uncompressedSizeInBytes() {
        return this.uncompressedSizeInBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.className());
        hashCode = 31 * hashCode + Objects.hashCode(this.uncompressedSizeInBytes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginProperties)) {
            return false;
        }
        PluginProperties other = (PluginProperties)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.className(), other.className()) && Objects.equals(this.uncompressedSizeInBytes(), other.uncompressedSizeInBytes());
    }

    public final String toString() {
        return ToString.builder((String)"PluginProperties").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Version", (Object)this.version()).add("ClassName", (Object)this.className()).add("UncompressedSizeInBytes", (Object)this.uncompressedSizeInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "ClassName": {
                return Optional.ofNullable(clazz.cast(this.className()));
            }
            case "UncompressedSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.uncompressedSizeInBytes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PluginProperties, T> g) {
        return obj -> g.apply((PluginProperties)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String version;
        private String className;
        private Long uncompressedSizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(PluginProperties model) {
            this.name(model.name);
            this.description(model.description);
            this.version(model.version);
            this.className(model.className);
            this.uncompressedSizeInBytes(model.uncompressedSizeInBytes);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getClassName() {
            return this.className;
        }

        public final void setClassName(String className) {
            this.className = className;
        }

        @Override
        public final Builder className(String className) {
            this.className = className;
            return this;
        }

        public final Long getUncompressedSizeInBytes() {
            return this.uncompressedSizeInBytes;
        }

        public final void setUncompressedSizeInBytes(Long uncompressedSizeInBytes) {
            this.uncompressedSizeInBytes = uncompressedSizeInBytes;
        }

        @Override
        public final Builder uncompressedSizeInBytes(Long uncompressedSizeInBytes) {
            this.uncompressedSizeInBytes = uncompressedSizeInBytes;
            return this;
        }

        public PluginProperties build() {
            return new PluginProperties(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PluginProperties> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder version(String var1);

        public Builder className(String var1);

        public Builder uncompressedSizeInBytes(Long var1);
    }
}

