/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MaintenanceType {
    REBOOT_NODE("REBOOT_NODE"),
    RESTART_SEARCH_PROCESS("RESTART_SEARCH_PROCESS"),
    RESTART_DASHBOARD("RESTART_DASHBOARD"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MaintenanceType> VALUE_MAP;
    private final String value;

    private MaintenanceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MaintenanceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MaintenanceType> knownValues() {
        EnumSet<MaintenanceType> knownValues = EnumSet.allOf(MaintenanceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MaintenanceType.class, MaintenanceType::toString);
    }
}

