/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearch.model.OpenSearchResponse;
import software.amazon.awssdk.services.opensearch.model.ReservedInstanceOffering;
import software.amazon.awssdk.services.opensearch.model.ReservedInstanceOfferingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedInstanceOfferingsResponse
extends OpenSearchResponse
implements ToCopyableBuilder<Builder, DescribeReservedInstanceOfferingsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeReservedInstanceOfferingsResponse.getter(DescribeReservedInstanceOfferingsResponse::nextToken)).setter(DescribeReservedInstanceOfferingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ReservedInstanceOffering>> RESERVED_INSTANCE_OFFERINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedInstanceOfferings").getter(DescribeReservedInstanceOfferingsResponse.getter(DescribeReservedInstanceOfferingsResponse::reservedInstanceOfferings)).setter(DescribeReservedInstanceOfferingsResponse.setter(Builder::reservedInstanceOfferings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstanceOfferings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedInstanceOffering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, RESERVED_INSTANCE_OFFERINGS_FIELD));
    private final String nextToken;
    private final List<ReservedInstanceOffering> reservedInstanceOfferings;

    private DescribeReservedInstanceOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reservedInstanceOfferings = builder.reservedInstanceOfferings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasReservedInstanceOfferings() {
        return this.reservedInstanceOfferings != null && !(this.reservedInstanceOfferings instanceof SdkAutoConstructList);
    }

    public final List<ReservedInstanceOffering> reservedInstanceOfferings() {
        return this.reservedInstanceOfferings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedInstanceOfferings() ? this.reservedInstanceOfferings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstanceOfferingsResponse)) {
            return false;
        }
        DescribeReservedInstanceOfferingsResponse other = (DescribeReservedInstanceOfferingsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasReservedInstanceOfferings() == other.hasReservedInstanceOfferings() && Objects.equals(this.reservedInstanceOfferings(), other.reservedInstanceOfferings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReservedInstanceOfferingsResponse").add("NextToken", (Object)this.nextToken()).add("ReservedInstanceOfferings", this.hasReservedInstanceOfferings() ? this.reservedInstanceOfferings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "ReservedInstanceOfferings": {
                return Optional.ofNullable(clazz.cast(this.reservedInstanceOfferings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedInstanceOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeReservedInstanceOfferingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ReservedInstanceOffering> reservedInstanceOfferings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstanceOfferingsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.reservedInstanceOfferings(model.reservedInstanceOfferings);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ReservedInstanceOffering.Builder> getReservedInstanceOfferings() {
            List<ReservedInstanceOffering.Builder> result = ReservedInstanceOfferingListCopier.copyToBuilder(this.reservedInstanceOfferings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReservedInstanceOfferings(Collection<ReservedInstanceOffering.BuilderImpl> reservedInstanceOfferings) {
            this.reservedInstanceOfferings = ReservedInstanceOfferingListCopier.copyFromBuilder(reservedInstanceOfferings);
        }

        @Override
        public final Builder reservedInstanceOfferings(Collection<ReservedInstanceOffering> reservedInstanceOfferings) {
            this.reservedInstanceOfferings = ReservedInstanceOfferingListCopier.copy(reservedInstanceOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstanceOfferings(ReservedInstanceOffering ... reservedInstanceOfferings) {
            this.reservedInstanceOfferings(Arrays.asList(reservedInstanceOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstanceOfferings(Consumer<ReservedInstanceOffering.Builder> ... reservedInstanceOfferings) {
            this.reservedInstanceOfferings(Stream.of(reservedInstanceOfferings).map(c -> (ReservedInstanceOffering)((ReservedInstanceOffering.Builder)ReservedInstanceOffering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeReservedInstanceOfferingsResponse build() {
            return new DescribeReservedInstanceOfferingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpenSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedInstanceOfferingsResponse> {
        public Builder nextToken(String var1);

        public Builder reservedInstanceOfferings(Collection<ReservedInstanceOffering> var1);

        public Builder reservedInstanceOfferings(ReservedInstanceOffering ... var1);

        public Builder reservedInstanceOfferings(Consumer<ReservedInstanceOffering.Builder> ... var1);
    }
}

