/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse;
import software.amazon.awssdk.services.omics.model.VariantImportJobItem;

public class ListVariantImportJobsIterable
implements SdkIterable<ListVariantImportJobsResponse> {
    private final OmicsClient client;
    private final ListVariantImportJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListVariantImportJobsIterable(OmicsClient client, ListVariantImportJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListVariantImportJobsResponseFetcher();
    }

    public Iterator<ListVariantImportJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VariantImportJobItem> variantImportJobs() {
        Function<ListVariantImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.variantImportJobs() != null) {
                return response.variantImportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListVariantImportJobsResponseFetcher
    implements SyncPageFetcher<ListVariantImportJobsResponse> {
        private ListVariantImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListVariantImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListVariantImportJobsResponse nextPage(ListVariantImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListVariantImportJobsIterable.this.client.listVariantImportJobs(ListVariantImportJobsIterable.this.firstRequest);
            }
            return ListVariantImportJobsIterable.this.client.listVariantImportJobs((ListVariantImportJobsRequest)((Object)ListVariantImportJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

