/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.ReadSetPartSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompleteReadSetUploadPartListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompleteReadSetUploadPartListItem> {
    private static final SdkField<Integer> PART_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("partNumber").getter(CompleteReadSetUploadPartListItem.getter(CompleteReadSetUploadPartListItem::partNumber)).setter(CompleteReadSetUploadPartListItem.setter(Builder::partNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partNumber").build()}).build();
    private static final SdkField<String> PART_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("partSource").getter(CompleteReadSetUploadPartListItem.getter(CompleteReadSetUploadPartListItem::partSourceAsString)).setter(CompleteReadSetUploadPartListItem.setter(Builder::partSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partSource").build()}).build();
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("checksum").getter(CompleteReadSetUploadPartListItem.getter(CompleteReadSetUploadPartListItem::checksum)).setter(CompleteReadSetUploadPartListItem.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("checksum").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PART_NUMBER_FIELD, PART_SOURCE_FIELD, CHECKSUM_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer partNumber;
    private final String partSource;
    private final String checksum;

    private CompleteReadSetUploadPartListItem(BuilderImpl builder) {
        this.partNumber = builder.partNumber;
        this.partSource = builder.partSource;
        this.checksum = builder.checksum;
    }

    public final Integer partNumber() {
        return this.partNumber;
    }

    public final ReadSetPartSource partSource() {
        return ReadSetPartSource.fromValue(this.partSource);
    }

    public final String partSourceAsString() {
        return this.partSource;
    }

    public final String checksum() {
        return this.checksum;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.partNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.partSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteReadSetUploadPartListItem)) {
            return false;
        }
        CompleteReadSetUploadPartListItem other = (CompleteReadSetUploadPartListItem)obj;
        return Objects.equals(this.partNumber(), other.partNumber()) && Objects.equals(this.partSourceAsString(), other.partSourceAsString()) && Objects.equals(this.checksum(), other.checksum());
    }

    public final String toString() {
        return ToString.builder((String)"CompleteReadSetUploadPartListItem").add("PartNumber", (Object)this.partNumber()).add("PartSource", (Object)this.partSourceAsString()).add("Checksum", (Object)this.checksum()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "partNumber": {
                return Optional.ofNullable(clazz.cast(this.partNumber()));
            }
            case "partSource": {
                return Optional.ofNullable(clazz.cast(this.partSourceAsString()));
            }
            case "checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompleteReadSetUploadPartListItem, T> g) {
        return obj -> g.apply((CompleteReadSetUploadPartListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer partNumber;
        private String partSource;
        private String checksum;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteReadSetUploadPartListItem model) {
            this.partNumber(model.partNumber);
            this.partSource(model.partSource);
            this.checksum(model.checksum);
        }

        public final Integer getPartNumber() {
            return this.partNumber;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public final String getPartSource() {
            return this.partSource;
        }

        public final void setPartSource(String partSource) {
            this.partSource = partSource;
        }

        @Override
        public final Builder partSource(String partSource) {
            this.partSource = partSource;
            return this;
        }

        @Override
        public final Builder partSource(ReadSetPartSource partSource) {
            this.partSource(partSource == null ? null : partSource.toString());
            return this;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public CompleteReadSetUploadPartListItem build() {
            return new CompleteReadSetUploadPartListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompleteReadSetUploadPartListItem> {
        public Builder partNumber(Integer var1);

        public Builder partSource(String var1);

        public Builder partSource(ReadSetPartSource var1);

        public Builder checksum(String var1);
    }
}

