/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.nimble;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.nimble.model.AcceptEulasRequest;
import software.amazon.awssdk.services.nimble.model.AcceptEulasResponse;
import software.amazon.awssdk.services.nimble.model.AccessDeniedException;
import software.amazon.awssdk.services.nimble.model.ConflictException;
import software.amazon.awssdk.services.nimble.model.CreateLaunchProfileRequest;
import software.amazon.awssdk.services.nimble.model.CreateLaunchProfileResponse;
import software.amazon.awssdk.services.nimble.model.CreateStreamingImageRequest;
import software.amazon.awssdk.services.nimble.model.CreateStreamingImageResponse;
import software.amazon.awssdk.services.nimble.model.CreateStreamingSessionRequest;
import software.amazon.awssdk.services.nimble.model.CreateStreamingSessionResponse;
import software.amazon.awssdk.services.nimble.model.CreateStreamingSessionStreamRequest;
import software.amazon.awssdk.services.nimble.model.CreateStreamingSessionStreamResponse;
import software.amazon.awssdk.services.nimble.model.CreateStudioComponentRequest;
import software.amazon.awssdk.services.nimble.model.CreateStudioComponentResponse;
import software.amazon.awssdk.services.nimble.model.CreateStudioRequest;
import software.amazon.awssdk.services.nimble.model.CreateStudioResponse;
import software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileMemberRequest;
import software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileMemberResponse;
import software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileRequest;
import software.amazon.awssdk.services.nimble.model.DeleteLaunchProfileResponse;
import software.amazon.awssdk.services.nimble.model.DeleteStreamingImageRequest;
import software.amazon.awssdk.services.nimble.model.DeleteStreamingImageResponse;
import software.amazon.awssdk.services.nimble.model.DeleteStreamingSessionRequest;
import software.amazon.awssdk.services.nimble.model.DeleteStreamingSessionResponse;
import software.amazon.awssdk.services.nimble.model.DeleteStudioComponentRequest;
import software.amazon.awssdk.services.nimble.model.DeleteStudioComponentResponse;
import software.amazon.awssdk.services.nimble.model.DeleteStudioMemberRequest;
import software.amazon.awssdk.services.nimble.model.DeleteStudioMemberResponse;
import software.amazon.awssdk.services.nimble.model.DeleteStudioRequest;
import software.amazon.awssdk.services.nimble.model.DeleteStudioResponse;
import software.amazon.awssdk.services.nimble.model.GetEulaRequest;
import software.amazon.awssdk.services.nimble.model.GetEulaResponse;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsRequest;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileDetailsResponse;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileInitializationRequest;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileInitializationResponse;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileMemberRequest;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileMemberResponse;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileRequest;
import software.amazon.awssdk.services.nimble.model.GetLaunchProfileResponse;
import software.amazon.awssdk.services.nimble.model.GetStreamingImageRequest;
import software.amazon.awssdk.services.nimble.model.GetStreamingImageResponse;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionBackupRequest;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionBackupResponse;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionRequest;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionResponse;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamRequest;
import software.amazon.awssdk.services.nimble.model.GetStreamingSessionStreamResponse;
import software.amazon.awssdk.services.nimble.model.GetStudioComponentRequest;
import software.amazon.awssdk.services.nimble.model.GetStudioComponentResponse;
import software.amazon.awssdk.services.nimble.model.GetStudioMemberRequest;
import software.amazon.awssdk.services.nimble.model.GetStudioMemberResponse;
import software.amazon.awssdk.services.nimble.model.GetStudioRequest;
import software.amazon.awssdk.services.nimble.model.GetStudioResponse;
import software.amazon.awssdk.services.nimble.model.InternalServerErrorException;
import software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesRequest;
import software.amazon.awssdk.services.nimble.model.ListEulaAcceptancesResponse;
import software.amazon.awssdk.services.nimble.model.ListEulasRequest;
import software.amazon.awssdk.services.nimble.model.ListEulasResponse;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersRequest;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfileMembersResponse;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfilesRequest;
import software.amazon.awssdk.services.nimble.model.ListLaunchProfilesResponse;
import software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest;
import software.amazon.awssdk.services.nimble.model.ListStreamingImagesResponse;
import software.amazon.awssdk.services.nimble.model.ListStreamingSessionBackupsRequest;
import software.amazon.awssdk.services.nimble.model.ListStreamingSessionBackupsResponse;
import software.amazon.awssdk.services.nimble.model.ListStreamingSessionsRequest;
import software.amazon.awssdk.services.nimble.model.ListStreamingSessionsResponse;
import software.amazon.awssdk.services.nimble.model.ListStudioComponentsRequest;
import software.amazon.awssdk.services.nimble.model.ListStudioComponentsResponse;
import software.amazon.awssdk.services.nimble.model.ListStudioMembersRequest;
import software.amazon.awssdk.services.nimble.model.ListStudioMembersResponse;
import software.amazon.awssdk.services.nimble.model.ListStudiosRequest;
import software.amazon.awssdk.services.nimble.model.ListStudiosResponse;
import software.amazon.awssdk.services.nimble.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.nimble.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.nimble.model.NimbleException;
import software.amazon.awssdk.services.nimble.model.PutLaunchProfileMembersRequest;
import software.amazon.awssdk.services.nimble.model.PutLaunchProfileMembersResponse;
import software.amazon.awssdk.services.nimble.model.PutStudioMembersRequest;
import software.amazon.awssdk.services.nimble.model.PutStudioMembersResponse;
import software.amazon.awssdk.services.nimble.model.ResourceNotFoundException;
import software.amazon.awssdk.services.nimble.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.nimble.model.StartStreamingSessionRequest;
import software.amazon.awssdk.services.nimble.model.StartStreamingSessionResponse;
import software.amazon.awssdk.services.nimble.model.StartStudioSsoConfigurationRepairRequest;
import software.amazon.awssdk.services.nimble.model.StartStudioSsoConfigurationRepairResponse;
import software.amazon.awssdk.services.nimble.model.StopStreamingSessionRequest;
import software.amazon.awssdk.services.nimble.model.StopStreamingSessionResponse;
import software.amazon.awssdk.services.nimble.model.TagResourceRequest;
import software.amazon.awssdk.services.nimble.model.TagResourceResponse;
import software.amazon.awssdk.services.nimble.model.ThrottlingException;
import software.amazon.awssdk.services.nimble.model.UntagResourceRequest;
import software.amazon.awssdk.services.nimble.model.UntagResourceResponse;
import software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileMemberRequest;
import software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileMemberResponse;
import software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileRequest;
import software.amazon.awssdk.services.nimble.model.UpdateLaunchProfileResponse;
import software.amazon.awssdk.services.nimble.model.UpdateStreamingImageRequest;
import software.amazon.awssdk.services.nimble.model.UpdateStreamingImageResponse;
import software.amazon.awssdk.services.nimble.model.UpdateStudioComponentRequest;
import software.amazon.awssdk.services.nimble.model.UpdateStudioComponentResponse;
import software.amazon.awssdk.services.nimble.model.UpdateStudioRequest;
import software.amazon.awssdk.services.nimble.model.UpdateStudioResponse;
import software.amazon.awssdk.services.nimble.model.ValidationException;
import software.amazon.awssdk.services.nimble.transform.AcceptEulasRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.CreateLaunchProfileRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.CreateStreamingImageRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.CreateStreamingSessionRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.CreateStreamingSessionStreamRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.CreateStudioComponentRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.CreateStudioRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.DeleteLaunchProfileMemberRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.DeleteLaunchProfileRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.DeleteStreamingImageRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.DeleteStreamingSessionRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.DeleteStudioComponentRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.DeleteStudioMemberRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.DeleteStudioRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetEulaRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetLaunchProfileDetailsRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetLaunchProfileInitializationRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetLaunchProfileMemberRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetLaunchProfileRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetStreamingImageRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetStreamingSessionBackupRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetStreamingSessionRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetStreamingSessionStreamRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetStudioComponentRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetStudioMemberRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.GetStudioRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListEulaAcceptancesRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListEulasRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListLaunchProfileMembersRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListLaunchProfilesRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListStreamingImagesRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListStreamingSessionBackupsRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListStreamingSessionsRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListStudioComponentsRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListStudioMembersRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListStudiosRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.PutLaunchProfileMembersRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.PutStudioMembersRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.StartStreamingSessionRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.StartStudioSsoConfigurationRepairRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.StopStreamingSessionRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.UpdateLaunchProfileMemberRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.UpdateLaunchProfileRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.UpdateStreamingImageRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.UpdateStudioComponentRequestMarshaller;
import software.amazon.awssdk.services.nimble.transform.UpdateStudioRequestMarshaller;
import software.amazon.awssdk.services.nimble.waiters.NimbleWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link NimbleClient}.
 *
 * @see NimbleClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultNimbleClient implements NimbleClient {
    private static final Logger log = Logger.loggerFor(DefaultNimbleClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final NimbleServiceClientConfiguration serviceClientConfiguration;

    protected DefaultNimbleClient(NimbleServiceClientConfiguration serviceClientConfiguration,
            SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Accept EULAs.
     * </p>
     *
     * @param acceptEulasRequest
     * @return Result of the AcceptEulas operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.AcceptEulas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/AcceptEulas" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AcceptEulasResponse acceptEulas(AcceptEulasRequest acceptEulasRequest) throws ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AcceptEulasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AcceptEulasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptEulasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptEulas");

            return clientHandler.execute(new ClientExecutionParams<AcceptEulasRequest, AcceptEulasResponse>()
                    .withOperationName("AcceptEulas").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(acceptEulasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AcceptEulasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a launch profile.
     * </p>
     *
     * @param createLaunchProfileRequest
     * @return Result of the CreateLaunchProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.CreateLaunchProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateLaunchProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateLaunchProfileResponse createLaunchProfile(CreateLaunchProfileRequest createLaunchProfileRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateLaunchProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateLaunchProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLaunchProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLaunchProfile");

            return clientHandler.execute(new ClientExecutionParams<CreateLaunchProfileRequest, CreateLaunchProfileResponse>()
                    .withOperationName("CreateLaunchProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createLaunchProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateLaunchProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a streaming image resource in a studio.
     * </p>
     *
     * @param createStreamingImageRequest
     * @return Result of the CreateStreamingImage operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.CreateStreamingImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingImage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateStreamingImageResponse createStreamingImage(CreateStreamingImageRequest createStreamingImageRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateStreamingImageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateStreamingImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStreamingImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStreamingImage");

            return clientHandler.execute(new ClientExecutionParams<CreateStreamingImageRequest, CreateStreamingImageResponse>()
                    .withOperationName("CreateStreamingImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createStreamingImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateStreamingImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a streaming session in a studio.
     * </p>
     * <p>
     * After invoking this operation, you must poll GetStreamingSession until the streaming session is in the
     * <code>READY</code> state.
     * </p>
     *
     * @param createStreamingSessionRequest
     * @return Result of the CreateStreamingSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.CreateStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateStreamingSessionResponse createStreamingSession(CreateStreamingSessionRequest createStreamingSessionRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateStreamingSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateStreamingSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStreamingSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStreamingSession");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateStreamingSessionRequest, CreateStreamingSessionResponse>()
                            .withOperationName("CreateStreamingSession").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createStreamingSessionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateStreamingSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a streaming session stream for a streaming session.
     * </p>
     * <p>
     * After invoking this API, invoke GetStreamingSessionStream with the returned streamId to poll the resource until
     * it is in the <code>READY</code> state.
     * </p>
     *
     * @param createStreamingSessionStreamRequest
     * @return Result of the CreateStreamingSessionStream operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.CreateStreamingSessionStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStreamingSessionStream"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateStreamingSessionStreamResponse createStreamingSessionStream(
            CreateStreamingSessionStreamRequest createStreamingSessionStreamRequest) throws ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateStreamingSessionStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateStreamingSessionStreamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStreamingSessionStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStreamingSessionStream");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateStreamingSessionStreamRequest, CreateStreamingSessionStreamResponse>()
                            .withOperationName("CreateStreamingSessionStream").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createStreamingSessionStreamRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateStreamingSessionStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Create a new studio.
     * </p>
     * <p>
     * When creating a studio, two IAM roles must be provided: the admin role and the user role. These roles are assumed
     * by your users when they log in to the Nimble Studio portal.
     * </p>
     * <p>
     * The user role must have the <code>AmazonNimbleStudio-StudioUser</code> managed policy attached for the portal to
     * function properly.
     * </p>
     * <p>
     * The admin role must have the <code>AmazonNimbleStudio-StudioAdmin</code> managed policy attached for the portal
     * to function properly.
     * </p>
     * <p>
     * You may optionally specify a KMS key in the <code>StudioEncryptionConfiguration</code>.
     * </p>
     * <p>
     * In Nimble Studio, resource names, descriptions, initialization scripts, and other data you provide are always
     * encrypted at rest using an KMS key. By default, this key is owned by Amazon Web Services and managed on your
     * behalf. You may provide your own KMS key when calling <code>CreateStudio</code> to encrypt this data using a key
     * you own and manage.
     * </p>
     * <p>
     * When providing an KMS key during studio creation, Nimble Studio creates KMS grants in your account to provide
     * your studio user and admin roles access to these KMS keys.
     * </p>
     * <p>
     * If you delete this grant, the studio will no longer be accessible to your portal users.
     * </p>
     * <p>
     * If you delete the studio KMS key, your studio will no longer be accessible.
     * </p>
     *
     * @param createStudioRequest
     * @return Result of the CreateStudio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.CreateStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStudio" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateStudioResponse createStudio(CreateStudioRequest createStudioRequest) throws ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateStudioResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateStudioResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStudioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStudio");

            return clientHandler.execute(new ClientExecutionParams<CreateStudioRequest, CreateStudioResponse>()
                    .withOperationName("CreateStudio").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createStudioRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateStudioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a studio component resource.
     * </p>
     *
     * @param createStudioComponentRequest
     * @return Result of the CreateStudioComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.CreateStudioComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/CreateStudioComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateStudioComponentResponse createStudioComponent(CreateStudioComponentRequest createStudioComponentRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateStudioComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateStudioComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStudioComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStudioComponent");

            return clientHandler.execute(new ClientExecutionParams<CreateStudioComponentRequest, CreateStudioComponentResponse>()
                    .withOperationName("CreateStudioComponent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createStudioComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateStudioComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Permanently delete a launch profile.
     * </p>
     *
     * @param deleteLaunchProfileRequest
     * @return Result of the DeleteLaunchProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.DeleteLaunchProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteLaunchProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteLaunchProfileResponse deleteLaunchProfile(DeleteLaunchProfileRequest deleteLaunchProfileRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteLaunchProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteLaunchProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLaunchProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLaunchProfile");

            return clientHandler.execute(new ClientExecutionParams<DeleteLaunchProfileRequest, DeleteLaunchProfileResponse>()
                    .withOperationName("DeleteLaunchProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteLaunchProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteLaunchProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a user from launch profile membership.
     * </p>
     *
     * @param deleteLaunchProfileMemberRequest
     * @return Result of the DeleteLaunchProfileMember operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.DeleteLaunchProfileMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteLaunchProfileMember"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteLaunchProfileMemberResponse deleteLaunchProfileMember(
            DeleteLaunchProfileMemberRequest deleteLaunchProfileMemberRequest) throws ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteLaunchProfileMemberResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteLaunchProfileMemberResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLaunchProfileMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLaunchProfileMember");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteLaunchProfileMemberRequest, DeleteLaunchProfileMemberResponse>()
                            .withOperationName("DeleteLaunchProfileMember").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteLaunchProfileMemberRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteLaunchProfileMemberRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete streaming image.
     * </p>
     *
     * @param deleteStreamingImageRequest
     * @return Result of the DeleteStreamingImage operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.DeleteStreamingImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStreamingImage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteStreamingImageResponse deleteStreamingImage(DeleteStreamingImageRequest deleteStreamingImageRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteStreamingImageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteStreamingImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStreamingImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStreamingImage");

            return clientHandler.execute(new ClientExecutionParams<DeleteStreamingImageRequest, DeleteStreamingImageResponse>()
                    .withOperationName("DeleteStreamingImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteStreamingImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteStreamingImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes streaming session resource.
     * </p>
     * <p>
     * After invoking this operation, use GetStreamingSession to poll the resource until it transitions to a
     * <code>DELETED</code> state.
     * </p>
     * <p>
     * A streaming session will count against your streaming session quota until it is marked <code>DELETED</code>.
     * </p>
     *
     * @param deleteStreamingSessionRequest
     * @return Result of the DeleteStreamingSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.DeleteStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteStreamingSessionResponse deleteStreamingSession(DeleteStreamingSessionRequest deleteStreamingSessionRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteStreamingSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteStreamingSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStreamingSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStreamingSession");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteStreamingSessionRequest, DeleteStreamingSessionResponse>()
                            .withOperationName("DeleteStreamingSession").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteStreamingSessionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteStreamingSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a studio resource.
     * </p>
     *
     * @param deleteStudioRequest
     * @return Result of the DeleteStudio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.DeleteStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudio" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteStudioResponse deleteStudio(DeleteStudioRequest deleteStudioRequest) throws ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteStudioResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteStudioResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStudioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStudio");

            return clientHandler.execute(new ClientExecutionParams<DeleteStudioRequest, DeleteStudioResponse>()
                    .withOperationName("DeleteStudio").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteStudioRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteStudioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a studio component resource.
     * </p>
     *
     * @param deleteStudioComponentRequest
     * @return Result of the DeleteStudioComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.DeleteStudioComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudioComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteStudioComponentResponse deleteStudioComponent(DeleteStudioComponentRequest deleteStudioComponentRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteStudioComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteStudioComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStudioComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStudioComponent");

            return clientHandler.execute(new ClientExecutionParams<DeleteStudioComponentRequest, DeleteStudioComponentResponse>()
                    .withOperationName("DeleteStudioComponent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteStudioComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteStudioComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a user from studio membership.
     * </p>
     *
     * @param deleteStudioMemberRequest
     * @return Result of the DeleteStudioMember operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.DeleteStudioMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/DeleteStudioMember" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteStudioMemberResponse deleteStudioMember(DeleteStudioMemberRequest deleteStudioMemberRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteStudioMemberResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteStudioMemberResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStudioMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStudioMember");

            return clientHandler.execute(new ClientExecutionParams<DeleteStudioMemberRequest, DeleteStudioMemberResponse>()
                    .withOperationName("DeleteStudioMember").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteStudioMemberRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteStudioMemberRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get EULA.
     * </p>
     *
     * @param getEulaRequest
     * @return Result of the GetEula operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.GetEula
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetEula" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetEulaResponse getEula(GetEulaRequest getEulaRequest) throws ResourceNotFoundException, ConflictException,
            ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEulaResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEulaResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEulaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEula");

            return clientHandler.execute(new ClientExecutionParams<GetEulaRequest, GetEulaResponse>()
                    .withOperationName("GetEula").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getEulaRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetEulaRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a launch profile.
     * </p>
     *
     * @param getLaunchProfileRequest
     * @return Result of the GetLaunchProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.GetLaunchProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetLaunchProfileResponse getLaunchProfile(GetLaunchProfileRequest getLaunchProfileRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLaunchProfileResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetLaunchProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLaunchProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLaunchProfile");

            return clientHandler.execute(new ClientExecutionParams<GetLaunchProfileRequest, GetLaunchProfileResponse>()
                    .withOperationName("GetLaunchProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getLaunchProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLaunchProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Launch profile details include the launch profile resource and summary information of resources that are used by,
     * or available to, the launch profile. This includes the name and description of all studio components used by the
     * launch profiles, and the name and description of streaming images that can be used with this launch profile.
     * </p>
     *
     * @param getLaunchProfileDetailsRequest
     * @return Result of the GetLaunchProfileDetails operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.GetLaunchProfileDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetLaunchProfileDetailsResponse getLaunchProfileDetails(GetLaunchProfileDetailsRequest getLaunchProfileDetailsRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLaunchProfileDetailsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLaunchProfileDetailsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLaunchProfileDetailsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLaunchProfileDetails");

            return clientHandler
                    .execute(new ClientExecutionParams<GetLaunchProfileDetailsRequest, GetLaunchProfileDetailsResponse>()
                            .withOperationName("GetLaunchProfileDetails").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getLaunchProfileDetailsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetLaunchProfileDetailsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a launch profile initialization.
     * </p>
     *
     * @param getLaunchProfileInitializationRequest
     * @return Result of the GetLaunchProfileInitialization operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.GetLaunchProfileInitialization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileInitialization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetLaunchProfileInitializationResponse getLaunchProfileInitialization(
            GetLaunchProfileInitializationRequest getLaunchProfileInitializationRequest) throws ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLaunchProfileInitializationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLaunchProfileInitializationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getLaunchProfileInitializationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLaunchProfileInitialization");

            return clientHandler
                    .execute(new ClientExecutionParams<GetLaunchProfileInitializationRequest, GetLaunchProfileInitializationResponse>()
                            .withOperationName("GetLaunchProfileInitialization").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getLaunchProfileInitializationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetLaunchProfileInitializationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a user persona in launch profile membership.
     * </p>
     *
     * @param getLaunchProfileMemberRequest
     * @return Result of the GetLaunchProfileMember operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.GetLaunchProfileMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetLaunchProfileMember" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetLaunchProfileMemberResponse getLaunchProfileMember(GetLaunchProfileMemberRequest getLaunchProfileMemberRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetLaunchProfileMemberResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetLaunchProfileMemberResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLaunchProfileMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLaunchProfileMember");

            return clientHandler
                    .execute(new ClientExecutionParams<GetLaunchProfileMemberRequest, GetLaunchProfileMemberResponse>()
                            .withOperationName("GetLaunchProfileMember").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getLaunchProfileMemberRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetLaunchProfileMemberRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get streaming image.
     * </p>
     *
     * @param getStreamingImageRequest
     * @return Result of the GetStreamingImage operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.GetStreamingImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingImage" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetStreamingImageResponse getStreamingImage(GetStreamingImageRequest getStreamingImageRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetStreamingImageResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetStreamingImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStreamingImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStreamingImage");

            return clientHandler.execute(new ClientExecutionParams<GetStreamingImageRequest, GetStreamingImageResponse>()
                    .withOperationName("GetStreamingImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getStreamingImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetStreamingImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets StreamingSession resource.
     * </p>
     * <p>
     * Invoke this operation to poll for a streaming session state while creating or deleting a session.
     * </p>
     *
     * @param getStreamingSessionRequest
     * @return Result of the GetStreamingSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.GetStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetStreamingSessionResponse getStreamingSession(GetStreamingSessionRequest getStreamingSessionRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetStreamingSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetStreamingSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStreamingSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStreamingSession");

            return clientHandler.execute(new ClientExecutionParams<GetStreamingSessionRequest, GetStreamingSessionResponse>()
                    .withOperationName("GetStreamingSession").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getStreamingSessionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetStreamingSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets <code>StreamingSessionBackup</code> resource.
     * </p>
     * <p>
     * Invoke this operation to poll for a streaming session backup while stopping a streaming session.
     * </p>
     *
     * @param getStreamingSessionBackupRequest
     * @return Result of the GetStreamingSessionBackup operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.GetStreamingSessionBackup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingSessionBackup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetStreamingSessionBackupResponse getStreamingSessionBackup(
            GetStreamingSessionBackupRequest getStreamingSessionBackupRequest) throws ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetStreamingSessionBackupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetStreamingSessionBackupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStreamingSessionBackupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStreamingSessionBackup");

            return clientHandler
                    .execute(new ClientExecutionParams<GetStreamingSessionBackupRequest, GetStreamingSessionBackupResponse>()
                            .withOperationName("GetStreamingSessionBackup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getStreamingSessionBackupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetStreamingSessionBackupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a StreamingSessionStream for a streaming session.
     * </p>
     * <p>
     * Invoke this operation to poll the resource after invoking <code>CreateStreamingSessionStream</code>.
     * </p>
     * <p>
     * After the <code>StreamingSessionStream</code> changes to the <code>READY</code> state, the url property will
     * contain a stream to be used with the DCV streaming client.
     * </p>
     *
     * @param getStreamingSessionStreamRequest
     * @return Result of the GetStreamingSessionStream operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.GetStreamingSessionStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStreamingSessionStream"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetStreamingSessionStreamResponse getStreamingSessionStream(
            GetStreamingSessionStreamRequest getStreamingSessionStreamRequest) throws ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetStreamingSessionStreamResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetStreamingSessionStreamResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStreamingSessionStreamRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStreamingSessionStream");

            return clientHandler
                    .execute(new ClientExecutionParams<GetStreamingSessionStreamRequest, GetStreamingSessionStreamResponse>()
                            .withOperationName("GetStreamingSessionStream").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getStreamingSessionStreamRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetStreamingSessionStreamRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a studio resource.
     * </p>
     *
     * @param getStudioRequest
     * @return Result of the GetStudio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.GetStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudio" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetStudioResponse getStudio(GetStudioRequest getStudioRequest) throws ResourceNotFoundException, ConflictException,
            ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetStudioResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetStudioResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStudioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStudio");

            return clientHandler.execute(new ClientExecutionParams<GetStudioRequest, GetStudioResponse>()
                    .withOperationName("GetStudio").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getStudioRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetStudioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a studio component resource.
     * </p>
     *
     * @param getStudioComponentRequest
     * @return Result of the GetStudioComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.GetStudioComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudioComponent" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetStudioComponentResponse getStudioComponent(GetStudioComponentRequest getStudioComponentRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetStudioComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetStudioComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStudioComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStudioComponent");

            return clientHandler.execute(new ClientExecutionParams<GetStudioComponentRequest, GetStudioComponentResponse>()
                    .withOperationName("GetStudioComponent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getStudioComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetStudioComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a user's membership in a studio.
     * </p>
     *
     * @param getStudioMemberRequest
     * @return Result of the GetStudioMember operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.GetStudioMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/GetStudioMember" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetStudioMemberResponse getStudioMember(GetStudioMemberRequest getStudioMemberRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetStudioMemberResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetStudioMemberResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStudioMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStudioMember");

            return clientHandler.execute(new ClientExecutionParams<GetStudioMemberRequest, GetStudioMemberResponse>()
                    .withOperationName("GetStudioMember").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getStudioMemberRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetStudioMemberRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List EULA acceptances.
     * </p>
     *
     * @param listEulaAcceptancesRequest
     * @return Result of the ListEulaAcceptances operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.ListEulaAcceptances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulaAcceptances" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListEulaAcceptancesResponse listEulaAcceptances(ListEulaAcceptancesRequest listEulaAcceptancesRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEulaAcceptancesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEulaAcceptancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEulaAcceptancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEulaAcceptances");

            return clientHandler.execute(new ClientExecutionParams<ListEulaAcceptancesRequest, ListEulaAcceptancesResponse>()
                    .withOperationName("ListEulaAcceptances").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listEulaAcceptancesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListEulaAcceptancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List EULAs.
     * </p>
     *
     * @param listEulasRequest
     * @return Result of the ListEulas operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.ListEulas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListEulas" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListEulasResponse listEulas(ListEulasRequest listEulasRequest) throws ResourceNotFoundException, ConflictException,
            ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEulasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListEulasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEulasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEulas");

            return clientHandler.execute(new ClientExecutionParams<ListEulasRequest, ListEulasResponse>()
                    .withOperationName("ListEulas").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listEulasRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListEulasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get all users in a given launch profile membership.
     * </p>
     *
     * @param listLaunchProfileMembersRequest
     * @return Result of the ListLaunchProfileMembers operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.ListLaunchProfileMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfileMembers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListLaunchProfileMembersResponse listLaunchProfileMembers(
            ListLaunchProfileMembersRequest listLaunchProfileMembersRequest) throws ResourceNotFoundException, ConflictException,
            ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLaunchProfileMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListLaunchProfileMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLaunchProfileMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLaunchProfileMembers");

            return clientHandler
                    .execute(new ClientExecutionParams<ListLaunchProfileMembersRequest, ListLaunchProfileMembersResponse>()
                            .withOperationName("ListLaunchProfileMembers").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listLaunchProfileMembersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListLaunchProfileMembersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List all the launch profiles a studio.
     * </p>
     *
     * @param listLaunchProfilesRequest
     * @return Result of the ListLaunchProfiles operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.ListLaunchProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListLaunchProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListLaunchProfilesResponse listLaunchProfiles(ListLaunchProfilesRequest listLaunchProfilesRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListLaunchProfilesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListLaunchProfilesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listLaunchProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListLaunchProfiles");

            return clientHandler.execute(new ClientExecutionParams<ListLaunchProfilesRequest, ListLaunchProfilesResponse>()
                    .withOperationName("ListLaunchProfiles").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listLaunchProfilesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListLaunchProfilesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the streaming image resources available to this studio.
     * </p>
     * <p>
     * This list will contain both images provided by Amazon Web Services, as well as streaming images that you have
     * created in your studio.
     * </p>
     *
     * @param listStreamingImagesRequest
     * @return Result of the ListStreamingImages operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.ListStreamingImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingImages" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListStreamingImagesResponse listStreamingImages(ListStreamingImagesRequest listStreamingImagesRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListStreamingImagesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListStreamingImagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStreamingImagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStreamingImages");

            return clientHandler.execute(new ClientExecutionParams<ListStreamingImagesRequest, ListStreamingImagesResponse>()
                    .withOperationName("ListStreamingImages").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listStreamingImagesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListStreamingImagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the backups of a streaming session in a studio.
     * </p>
     *
     * @param listStreamingSessionBackupsRequest
     * @return Result of the ListStreamingSessionBackups operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.ListStreamingSessionBackups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingSessionBackups"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListStreamingSessionBackupsResponse listStreamingSessionBackups(
            ListStreamingSessionBackupsRequest listStreamingSessionBackupsRequest) throws ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListStreamingSessionBackupsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListStreamingSessionBackupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStreamingSessionBackupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStreamingSessionBackups");

            return clientHandler
                    .execute(new ClientExecutionParams<ListStreamingSessionBackupsRequest, ListStreamingSessionBackupsResponse>()
                            .withOperationName("ListStreamingSessionBackups").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listStreamingSessionBackupsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListStreamingSessionBackupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the streaming sessions in a studio.
     * </p>
     *
     * @param listStreamingSessionsRequest
     * @return Result of the ListStreamingSessions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.ListStreamingSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStreamingSessions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListStreamingSessionsResponse listStreamingSessions(ListStreamingSessionsRequest listStreamingSessionsRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListStreamingSessionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListStreamingSessionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStreamingSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStreamingSessions");

            return clientHandler.execute(new ClientExecutionParams<ListStreamingSessionsRequest, ListStreamingSessionsResponse>()
                    .withOperationName("ListStreamingSessions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listStreamingSessionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListStreamingSessionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the <code>StudioComponents</code> in a studio.
     * </p>
     *
     * @param listStudioComponentsRequest
     * @return Result of the ListStudioComponents operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.ListStudioComponents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioComponents" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListStudioComponentsResponse listStudioComponents(ListStudioComponentsRequest listStudioComponentsRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListStudioComponentsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListStudioComponentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStudioComponentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStudioComponents");

            return clientHandler.execute(new ClientExecutionParams<ListStudioComponentsRequest, ListStudioComponentsResponse>()
                    .withOperationName("ListStudioComponents").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listStudioComponentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListStudioComponentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get all users in a given studio membership.
     * </p>
     * <note>
     * <p>
     * <code>ListStudioMembers</code> only returns admin members.
     * </p>
     * </note>
     *
     * @param listStudioMembersRequest
     * @return Result of the ListStudioMembers operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.ListStudioMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudioMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListStudioMembersResponse listStudioMembers(ListStudioMembersRequest listStudioMembersRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListStudioMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListStudioMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStudioMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStudioMembers");

            return clientHandler.execute(new ClientExecutionParams<ListStudioMembersRequest, ListStudioMembersResponse>()
                    .withOperationName("ListStudioMembers").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listStudioMembersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListStudioMembersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List studios in your Amazon Web Services accounts in the requested Amazon Web Services Region.
     * </p>
     *
     * @param listStudiosRequest
     * @return Result of the ListStudios operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.ListStudios
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListStudios" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListStudiosResponse listStudios(ListStudiosRequest listStudiosRequest) throws ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListStudiosResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListStudiosResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStudiosRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStudios");

            return clientHandler.execute(new ClientExecutionParams<ListStudiosRequest, ListStudiosResponse>()
                    .withOperationName("ListStudios").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listStudiosRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListStudiosRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the tags for a resource, given its Amazon Resource Names (ARN).
     * </p>
     * <p>
     * This operation supports ARNs for all resource types in Nimble Studio that support tags, including studio, studio
     * component, launch profile, streaming image, and streaming session. All resources that can be tagged will contain
     * an ARN property, so you do not have to create this ARN yourself.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Add/update users with given persona to launch profile membership.
     * </p>
     *
     * @param putLaunchProfileMembersRequest
     * @return Result of the PutLaunchProfileMembers operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.PutLaunchProfileMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/PutLaunchProfileMembers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutLaunchProfileMembersResponse putLaunchProfileMembers(PutLaunchProfileMembersRequest putLaunchProfileMembersRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutLaunchProfileMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutLaunchProfileMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putLaunchProfileMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutLaunchProfileMembers");

            return clientHandler
                    .execute(new ClientExecutionParams<PutLaunchProfileMembersRequest, PutLaunchProfileMembersResponse>()
                            .withOperationName("PutLaunchProfileMembers").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putLaunchProfileMembersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutLaunchProfileMembersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Add/update users with given persona to studio membership.
     * </p>
     *
     * @param putStudioMembersRequest
     * @return Result of the PutStudioMembers operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.PutStudioMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/PutStudioMembers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutStudioMembersResponse putStudioMembers(PutStudioMembersRequest putStudioMembersRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutStudioMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutStudioMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putStudioMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutStudioMembers");

            return clientHandler.execute(new ClientExecutionParams<PutStudioMembersRequest, PutStudioMembersResponse>()
                    .withOperationName("PutStudioMembers").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putStudioMembersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutStudioMembersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Transitions sessions from the <code>STOPPED</code> state into the <code>READY</code> state. The
     * <code>START_IN_PROGRESS</code> state is the intermediate state between the <code>STOPPED</code> and
     * <code>READY</code> states.
     * </p>
     *
     * @param startStreamingSessionRequest
     * @return Result of the StartStreamingSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.StartStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StartStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartStreamingSessionResponse startStreamingSession(StartStreamingSessionRequest startStreamingSessionRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartStreamingSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartStreamingSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startStreamingSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartStreamingSession");

            return clientHandler.execute(new ClientExecutionParams<StartStreamingSessionRequest, StartStreamingSessionResponse>()
                    .withOperationName("StartStreamingSession").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(startStreamingSessionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartStreamingSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Repairs the IAM Identity Center configuration for a given studio.
     * </p>
     * <p>
     * If the studio has a valid IAM Identity Center configuration currently associated with it, this operation will
     * fail with a validation error.
     * </p>
     * <p>
     * If the studio does not have a valid IAM Identity Center configuration currently associated with it, then a new
     * IAM Identity Center application is created for the studio and the studio is changed to the <code>READY</code>
     * state.
     * </p>
     * <p>
     * After the IAM Identity Center application is repaired, you must use the Amazon Nimble Studio console to add
     * administrators and users to your studio.
     * </p>
     *
     * @param startStudioSsoConfigurationRepairRequest
     * @return Result of the StartStudioSSOConfigurationRepair operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.StartStudioSSOConfigurationRepair
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StartStudioSSOConfigurationRepair"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartStudioSsoConfigurationRepairResponse startStudioSSOConfigurationRepair(
            StartStudioSsoConfigurationRepairRequest startStudioSsoConfigurationRepairRequest) throws ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartStudioSsoConfigurationRepairResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartStudioSsoConfigurationRepairResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startStudioSsoConfigurationRepairRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartStudioSSOConfigurationRepair");

            return clientHandler
                    .execute(new ClientExecutionParams<StartStudioSsoConfigurationRepairRequest, StartStudioSsoConfigurationRepairResponse>()
                            .withOperationName("StartStudioSSOConfigurationRepair").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(startStudioSsoConfigurationRepairRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartStudioSsoConfigurationRepairRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Transitions sessions from the <code>READY</code> state into the <code>STOPPED</code> state. The
     * <code>STOP_IN_PROGRESS</code> state is the intermediate state between the <code>READY</code> and
     * <code>STOPPED</code> states.
     * </p>
     *
     * @param stopStreamingSessionRequest
     * @return Result of the StopStreamingSession operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.StopStreamingSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StopStreamingSession" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StopStreamingSessionResponse stopStreamingSession(StopStreamingSessionRequest stopStreamingSessionRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopStreamingSessionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopStreamingSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopStreamingSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopStreamingSession");

            return clientHandler.execute(new ClientExecutionParams<StopStreamingSessionRequest, StopStreamingSessionResponse>()
                    .withOperationName("StopStreamingSession").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(stopStreamingSessionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StopStreamingSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates tags for a resource, given its ARN.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the tags for a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a launch profile.
     * </p>
     *
     * @param updateLaunchProfileRequest
     * @return Result of the UpdateLaunchProfile operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.UpdateLaunchProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateLaunchProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateLaunchProfileResponse updateLaunchProfile(UpdateLaunchProfileRequest updateLaunchProfileRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateLaunchProfileResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateLaunchProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLaunchProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLaunchProfile");

            return clientHandler.execute(new ClientExecutionParams<UpdateLaunchProfileRequest, UpdateLaunchProfileResponse>()
                    .withOperationName("UpdateLaunchProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateLaunchProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateLaunchProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a user persona in launch profile membership.
     * </p>
     *
     * @param updateLaunchProfileMemberRequest
     * @return Result of the UpdateLaunchProfileMember operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.UpdateLaunchProfileMember
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateLaunchProfileMember"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateLaunchProfileMemberResponse updateLaunchProfileMember(
            UpdateLaunchProfileMemberRequest updateLaunchProfileMemberRequest) throws ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateLaunchProfileMemberResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateLaunchProfileMemberResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLaunchProfileMemberRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLaunchProfileMember");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateLaunchProfileMemberRequest, UpdateLaunchProfileMemberResponse>()
                            .withOperationName("UpdateLaunchProfileMember").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateLaunchProfileMemberRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateLaunchProfileMemberRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update streaming image.
     * </p>
     *
     * @param updateStreamingImageRequest
     * @return Result of the UpdateStreamingImage operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.UpdateStreamingImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStreamingImage" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateStreamingImageResponse updateStreamingImage(UpdateStreamingImageRequest updateStreamingImageRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateStreamingImageResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateStreamingImageResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStreamingImageRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStreamingImage");

            return clientHandler.execute(new ClientExecutionParams<UpdateStreamingImageRequest, UpdateStreamingImageResponse>()
                    .withOperationName("UpdateStreamingImage").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateStreamingImageRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateStreamingImageRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a Studio resource.
     * </p>
     * <p>
     * Currently, this operation only supports updating the displayName of your studio.
     * </p>
     *
     * @param updateStudioRequest
     * @return Result of the UpdateStudio operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.UpdateStudio
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStudio" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateStudioResponse updateStudio(UpdateStudioRequest updateStudioRequest) throws ResourceNotFoundException,
            ConflictException, ThrottlingException, ValidationException, AccessDeniedException, InternalServerErrorException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateStudioResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateStudioResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStudioRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStudio");

            return clientHandler.execute(new ClientExecutionParams<UpdateStudioRequest, UpdateStudioResponse>()
                    .withOperationName("UpdateStudio").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateStudioRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateStudioRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a studio component resource.
     * </p>
     *
     * @param updateStudioComponentRequest
     * @return Result of the UpdateStudioComponent operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource could not be found.
     * @throws ConflictException
     *         Another operation is in progress.
     * @throws ThrottlingException
     *         The request throughput limit was exceeded.
     * @throws ValidationException
     *         One of the parameters in the request is invalid.
     * @throws AccessDeniedException
     *         You are not authorized to perform this operation. Check your IAM policies, and ensure that you are using
     *         the correct access keys.
     * @throws InternalServerErrorException
     *         An internal error has occurred. Please retry your request.
     * @throws ServiceQuotaExceededException
     *         Your current quota does not allow you to perform the request action. You can request increases for some
     *         quotas, and other quotas cannot be increased.</p>
     *         <p>
     *         Please use Amazon Web Services Service Quotas to request an increase.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NimbleException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NimbleClient.UpdateStudioComponent
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/UpdateStudioComponent" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateStudioComponentResponse updateStudioComponent(UpdateStudioComponentRequest updateStudioComponentRequest)
            throws ResourceNotFoundException, ConflictException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerErrorException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, NimbleException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateStudioComponentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateStudioComponentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStudioComponentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "nimble");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStudioComponent");

            return clientHandler.execute(new ClientExecutionParams<UpdateStudioComponentRequest, UpdateStudioComponentResponse>()
                    .withOperationName("UpdateStudioComponent").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateStudioComponentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateStudioComponentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create an instance of {@link NimbleWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link NimbleWaiter}
     */
    @Override
    public NimbleWaiter waiter() {
        return NimbleWaiter.builder().client(this).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(NimbleException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerErrorException")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).httpStatusCode(500).build());
    }

    @Override
    public final NimbleServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
