/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LaunchProfileValidationStatusCode {
    VALIDATION_NOT_STARTED("VALIDATION_NOT_STARTED"),
    VALIDATION_IN_PROGRESS("VALIDATION_IN_PROGRESS"),
    VALIDATION_SUCCESS("VALIDATION_SUCCESS"),
    VALIDATION_FAILED_INVALID_SUBNET_ROUTE_TABLE_ASSOCIATION("VALIDATION_FAILED_INVALID_SUBNET_ROUTE_TABLE_ASSOCIATION"),
    VALIDATION_FAILED_SUBNET_NOT_FOUND("VALIDATION_FAILED_SUBNET_NOT_FOUND"),
    VALIDATION_FAILED_INVALID_SECURITY_GROUP_ASSOCIATION("VALIDATION_FAILED_INVALID_SECURITY_GROUP_ASSOCIATION"),
    VALIDATION_FAILED_INVALID_ACTIVE_DIRECTORY("VALIDATION_FAILED_INVALID_ACTIVE_DIRECTORY"),
    VALIDATION_FAILED_UNAUTHORIZED("VALIDATION_FAILED_UNAUTHORIZED"),
    VALIDATION_FAILED_INTERNAL_SERVER_ERROR("VALIDATION_FAILED_INTERNAL_SERVER_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LaunchProfileValidationStatusCode> VALUE_MAP;
    private final String value;

    private LaunchProfileValidationStatusCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LaunchProfileValidationStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LaunchProfileValidationStatusCode> knownValues() {
        EnumSet<LaunchProfileValidationStatusCode> knownValues = EnumSet.allOf(LaunchProfileValidationStatusCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LaunchProfileValidationStatusCode.class, LaunchProfileValidationStatusCode::toString);
    }
}

