/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.nimble.model.EC2SubnetIdListCopier;
import software.amazon.awssdk.services.nimble.model.LaunchProfileProtocolVersionListCopier;
import software.amazon.awssdk.services.nimble.model.LaunchProfileState;
import software.amazon.awssdk.services.nimble.model.LaunchProfileStatusCode;
import software.amazon.awssdk.services.nimble.model.LaunchProfileStudioComponentIdListCopier;
import software.amazon.awssdk.services.nimble.model.StreamConfiguration;
import software.amazon.awssdk.services.nimble.model.TagsCopier;
import software.amazon.awssdk.services.nimble.model.ValidationResult;
import software.amazon.awssdk.services.nimble.model.ValidationResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchProfile
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchProfile> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(LaunchProfile.getter(LaunchProfile::arn)).setter(LaunchProfile.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(LaunchProfile.getter(LaunchProfile::createdAt)).setter(LaunchProfile.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(LaunchProfile.getter(LaunchProfile::createdBy)).setter(LaunchProfile.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(LaunchProfile.getter(LaunchProfile::description)).setter(LaunchProfile.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> EC2_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ec2SubnetIds").getter(LaunchProfile.getter(LaunchProfile::ec2SubnetIds)).setter(LaunchProfile.setter(Builder::ec2SubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2SubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAUNCH_PROFILE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchProfileId").getter(LaunchProfile.getter(LaunchProfile::launchProfileId)).setter(LaunchProfile.setter(Builder::launchProfileId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfileId").build()}).build();
    private static final SdkField<List<String>> LAUNCH_PROFILE_PROTOCOL_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("launchProfileProtocolVersions").getter(LaunchProfile.getter(LaunchProfile::launchProfileProtocolVersions)).setter(LaunchProfile.setter(Builder::launchProfileProtocolVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchProfileProtocolVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(LaunchProfile.getter(LaunchProfile::name)).setter(LaunchProfile.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(LaunchProfile.getter(LaunchProfile::stateAsString)).setter(LaunchProfile.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusCode").getter(LaunchProfile.getter(LaunchProfile::statusCodeAsString)).setter(LaunchProfile.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusCode").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(LaunchProfile.getter(LaunchProfile::statusMessage)).setter(LaunchProfile.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<StreamConfiguration> STREAM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("streamConfiguration").getter(LaunchProfile.getter(LaunchProfile::streamConfiguration)).setter(LaunchProfile.setter(Builder::streamConfiguration)).constructor(StreamConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamConfiguration").build()}).build();
    private static final SdkField<List<String>> STUDIO_COMPONENT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("studioComponentIds").getter(LaunchProfile.getter(LaunchProfile::studioComponentIds)).setter(LaunchProfile.setter(Builder::studioComponentIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("studioComponentIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(LaunchProfile.getter(LaunchProfile::tags)).setter(LaunchProfile.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(LaunchProfile.getter(LaunchProfile::updatedAt)).setter(LaunchProfile.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(LaunchProfile.getter(LaunchProfile::updatedBy)).setter(LaunchProfile.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final SdkField<List<ValidationResult>> VALIDATION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("validationResults").getter(LaunchProfile.getter(LaunchProfile::validationResults)).setter(LaunchProfile.setter(Builder::validationResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, EC2_SUBNET_IDS_FIELD, LAUNCH_PROFILE_ID_FIELD, LAUNCH_PROFILE_PROTOCOL_VERSIONS_FIELD, NAME_FIELD, STATE_FIELD, STATUS_CODE_FIELD, STATUS_MESSAGE_FIELD, STREAM_CONFIGURATION_FIELD, STUDIO_COMPONENT_IDS_FIELD, TAGS_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, VALIDATION_RESULTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant createdAt;
    private final String createdBy;
    private final String description;
    private final List<String> ec2SubnetIds;
    private final String launchProfileId;
    private final List<String> launchProfileProtocolVersions;
    private final String name;
    private final String state;
    private final String statusCodeValue;
    private final String statusMessage;
    private final StreamConfiguration streamConfiguration;
    private final List<String> studioComponentIds;
    private final Map<String, String> tags;
    private final Instant updatedAt;
    private final String updatedBy;
    private final List<ValidationResult> validationResults;

    private LaunchProfile(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.ec2SubnetIds = builder.ec2SubnetIds;
        this.launchProfileId = builder.launchProfileId;
        this.launchProfileProtocolVersions = builder.launchProfileProtocolVersions;
        this.name = builder.name;
        this.state = builder.state;
        this.statusCodeValue = builder.statusCodeValue;
        this.statusMessage = builder.statusMessage;
        this.streamConfiguration = builder.streamConfiguration;
        this.studioComponentIds = builder.studioComponentIds;
        this.tags = builder.tags;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.validationResults = builder.validationResults;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasEc2SubnetIds() {
        return this.ec2SubnetIds != null && !(this.ec2SubnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> ec2SubnetIds() {
        return this.ec2SubnetIds;
    }

    public final String launchProfileId() {
        return this.launchProfileId;
    }

    public final boolean hasLaunchProfileProtocolVersions() {
        return this.launchProfileProtocolVersions != null && !(this.launchProfileProtocolVersions instanceof SdkAutoConstructList);
    }

    public final List<String> launchProfileProtocolVersions() {
        return this.launchProfileProtocolVersions;
    }

    public final String name() {
        return this.name;
    }

    public final LaunchProfileState state() {
        return LaunchProfileState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final LaunchProfileStatusCode statusCode() {
        return LaunchProfileStatusCode.fromValue(this.statusCodeValue);
    }

    public final String statusCodeAsString() {
        return this.statusCodeValue;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final StreamConfiguration streamConfiguration() {
        return this.streamConfiguration;
    }

    public final boolean hasStudioComponentIds() {
        return this.studioComponentIds != null && !(this.studioComponentIds instanceof SdkAutoConstructList);
    }

    public final List<String> studioComponentIds() {
        return this.studioComponentIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public final boolean hasValidationResults() {
        return this.validationResults != null && !(this.validationResults instanceof SdkAutoConstructList);
    }

    public final List<ValidationResult> validationResults() {
        return this.validationResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2SubnetIds() ? this.ec2SubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.launchProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLaunchProfileProtocolVersions() ? this.launchProfileProtocolVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStudioComponentIds() ? this.studioComponentIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidationResults() ? this.validationResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchProfile)) {
            return false;
        }
        LaunchProfile other = (LaunchProfile)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.description(), other.description()) && this.hasEc2SubnetIds() == other.hasEc2SubnetIds() && Objects.equals(this.ec2SubnetIds(), other.ec2SubnetIds()) && Objects.equals(this.launchProfileId(), other.launchProfileId()) && this.hasLaunchProfileProtocolVersions() == other.hasLaunchProfileProtocolVersions() && Objects.equals(this.launchProfileProtocolVersions(), other.launchProfileProtocolVersions()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.streamConfiguration(), other.streamConfiguration()) && this.hasStudioComponentIds() == other.hasStudioComponentIds() && Objects.equals(this.studioComponentIds(), other.studioComponentIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy()) && this.hasValidationResults() == other.hasValidationResults() && Objects.equals(this.validationResults(), other.validationResults());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchProfile").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("Ec2SubnetIds", this.hasEc2SubnetIds() ? this.ec2SubnetIds() : null).add("LaunchProfileId", (Object)this.launchProfileId()).add("LaunchProfileProtocolVersions", this.hasLaunchProfileProtocolVersions() ? this.launchProfileProtocolVersions() : null).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("State", (Object)this.stateAsString()).add("StatusCode", (Object)this.statusCodeAsString()).add("StatusMessage", (Object)this.statusMessage()).add("StreamConfiguration", (Object)this.streamConfiguration()).add("StudioComponentIds", this.hasStudioComponentIds() ? this.studioComponentIds() : null).add("Tags", this.hasTags() ? this.tags() : null).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).add("ValidationResults", this.hasValidationResults() ? this.validationResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ec2SubnetIds": {
                return Optional.ofNullable(clazz.cast(this.ec2SubnetIds()));
            }
            case "launchProfileId": {
                return Optional.ofNullable(clazz.cast(this.launchProfileId()));
            }
            case "launchProfileProtocolVersions": {
                return Optional.ofNullable(clazz.cast(this.launchProfileProtocolVersions()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "statusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "streamConfiguration": {
                return Optional.ofNullable(clazz.cast(this.streamConfiguration()));
            }
            case "studioComponentIds": {
                return Optional.ofNullable(clazz.cast(this.studioComponentIds()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
            case "validationResults": {
                return Optional.ofNullable(clazz.cast(this.validationResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchProfile, T> g) {
        return obj -> g.apply((LaunchProfile)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private String createdBy;
        private String description;
        private List<String> ec2SubnetIds = DefaultSdkAutoConstructList.getInstance();
        private String launchProfileId;
        private List<String> launchProfileProtocolVersions = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private String state;
        private String statusCodeValue;
        private String statusMessage;
        private StreamConfiguration streamConfiguration;
        private List<String> studioComponentIds = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Instant updatedAt;
        private String updatedBy;
        private List<ValidationResult> validationResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchProfile model) {
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.description(model.description);
            this.ec2SubnetIds(model.ec2SubnetIds);
            this.launchProfileId(model.launchProfileId);
            this.launchProfileProtocolVersions(model.launchProfileProtocolVersions);
            this.name(model.name);
            this.state(model.state);
            this.statusCode(model.statusCodeValue);
            this.statusMessage(model.statusMessage);
            this.streamConfiguration(model.streamConfiguration);
            this.studioComponentIds(model.studioComponentIds);
            this.tags(model.tags);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
            this.validationResults(model.validationResults);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getEc2SubnetIds() {
            if (this.ec2SubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ec2SubnetIds;
        }

        public final void setEc2SubnetIds(Collection<String> ec2SubnetIds) {
            this.ec2SubnetIds = EC2SubnetIdListCopier.copy(ec2SubnetIds);
        }

        @Override
        public final Builder ec2SubnetIds(Collection<String> ec2SubnetIds) {
            this.ec2SubnetIds = EC2SubnetIdListCopier.copy(ec2SubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2SubnetIds(String ... ec2SubnetIds) {
            this.ec2SubnetIds(Arrays.asList(ec2SubnetIds));
            return this;
        }

        public final String getLaunchProfileId() {
            return this.launchProfileId;
        }

        public final void setLaunchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
        }

        @Override
        public final Builder launchProfileId(String launchProfileId) {
            this.launchProfileId = launchProfileId;
            return this;
        }

        public final Collection<String> getLaunchProfileProtocolVersions() {
            if (this.launchProfileProtocolVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.launchProfileProtocolVersions;
        }

        public final void setLaunchProfileProtocolVersions(Collection<String> launchProfileProtocolVersions) {
            this.launchProfileProtocolVersions = LaunchProfileProtocolVersionListCopier.copy(launchProfileProtocolVersions);
        }

        @Override
        public final Builder launchProfileProtocolVersions(Collection<String> launchProfileProtocolVersions) {
            this.launchProfileProtocolVersions = LaunchProfileProtocolVersionListCopier.copy(launchProfileProtocolVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchProfileProtocolVersions(String ... launchProfileProtocolVersions) {
            this.launchProfileProtocolVersions(Arrays.asList(launchProfileProtocolVersions));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(LaunchProfileState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusCode() {
            return this.statusCodeValue;
        }

        public final void setStatusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(String statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        @Override
        public final Builder statusCode(LaunchProfileStatusCode statusCodeValue) {
            this.statusCode(statusCodeValue == null ? null : statusCodeValue.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final StreamConfiguration.Builder getStreamConfiguration() {
            return this.streamConfiguration != null ? this.streamConfiguration.toBuilder() : null;
        }

        public final void setStreamConfiguration(StreamConfiguration.BuilderImpl streamConfiguration) {
            this.streamConfiguration = streamConfiguration != null ? streamConfiguration.build() : null;
        }

        @Override
        public final Builder streamConfiguration(StreamConfiguration streamConfiguration) {
            this.streamConfiguration = streamConfiguration;
            return this;
        }

        public final Collection<String> getStudioComponentIds() {
            if (this.studioComponentIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.studioComponentIds;
        }

        public final void setStudioComponentIds(Collection<String> studioComponentIds) {
            this.studioComponentIds = LaunchProfileStudioComponentIdListCopier.copy(studioComponentIds);
        }

        @Override
        public final Builder studioComponentIds(Collection<String> studioComponentIds) {
            this.studioComponentIds = LaunchProfileStudioComponentIdListCopier.copy(studioComponentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder studioComponentIds(String ... studioComponentIds) {
            this.studioComponentIds(Arrays.asList(studioComponentIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final List<ValidationResult.Builder> getValidationResults() {
            List<ValidationResult.Builder> result = ValidationResultsCopier.copyToBuilder(this.validationResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationResults(Collection<ValidationResult.BuilderImpl> validationResults) {
            this.validationResults = ValidationResultsCopier.copyFromBuilder(validationResults);
        }

        @Override
        public final Builder validationResults(Collection<ValidationResult> validationResults) {
            this.validationResults = ValidationResultsCopier.copy(validationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationResults(ValidationResult ... validationResults) {
            this.validationResults(Arrays.asList(validationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationResults(Consumer<ValidationResult.Builder> ... validationResults) {
            this.validationResults(Stream.of(validationResults).map(c -> (ValidationResult)((ValidationResult.Builder)ValidationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LaunchProfile build() {
            return new LaunchProfile(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchProfile> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder description(String var1);

        public Builder ec2SubnetIds(Collection<String> var1);

        public Builder ec2SubnetIds(String ... var1);

        public Builder launchProfileId(String var1);

        public Builder launchProfileProtocolVersions(Collection<String> var1);

        public Builder launchProfileProtocolVersions(String ... var1);

        public Builder name(String var1);

        public Builder state(String var1);

        public Builder state(LaunchProfileState var1);

        public Builder statusCode(String var1);

        public Builder statusCode(LaunchProfileStatusCode var1);

        public Builder statusMessage(String var1);

        public Builder streamConfiguration(StreamConfiguration var1);

        default public Builder streamConfiguration(Consumer<StreamConfiguration.Builder> streamConfiguration) {
            return this.streamConfiguration((StreamConfiguration)((StreamConfiguration.Builder)StreamConfiguration.builder().applyMutation(streamConfiguration)).build());
        }

        public Builder studioComponentIds(Collection<String> var1);

        public Builder studioComponentIds(String ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);

        public Builder validationResults(Collection<ValidationResult> var1);

        public Builder validationResults(ValidationResult ... var1);

        public Builder validationResults(Consumer<ValidationResult.Builder> ... var1);
    }
}

