/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.nimble.NimbleClient;
import software.amazon.awssdk.services.nimble.model.ListStreamingImagesRequest;
import software.amazon.awssdk.services.nimble.model.ListStreamingImagesResponse;
import software.amazon.awssdk.services.nimble.model.StreamingImage;

public class ListStreamingImagesIterable
implements SdkIterable<ListStreamingImagesResponse> {
    private final NimbleClient client;
    private final ListStreamingImagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamingImagesIterable(NimbleClient client, ListStreamingImagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStreamingImagesResponseFetcher();
    }

    public Iterator<ListStreamingImagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<StreamingImage> streamingImages() {
        Function<ListStreamingImagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.streamingImages() != null) {
                return response.streamingImages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListStreamingImagesResponseFetcher
    implements SyncPageFetcher<ListStreamingImagesResponse> {
        private ListStreamingImagesResponseFetcher() {
        }

        public boolean hasNextPage(ListStreamingImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListStreamingImagesResponse nextPage(ListStreamingImagesResponse previousPage) {
            if (previousPage == null) {
                return ListStreamingImagesIterable.this.client.listStreamingImages(ListStreamingImagesIterable.this.firstRequest);
            }
            return ListStreamingImagesIterable.this.client.listStreamingImages((ListStreamingImagesRequest)((Object)ListStreamingImagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

