/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.nimble.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.nimble.model.NimbleRequest;
import software.amazon.awssdk.services.nimble.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEulasRequest
extends NimbleRequest
implements ToCopyableBuilder<Builder, ListEulasRequest> {
    private static final SdkField<List<String>> EULA_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eulaIds").getter(ListEulasRequest.getter(ListEulasRequest::eulaIds)).setter(ListEulasRequest.setter(Builder::eulaIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("eulaIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEulasRequest.getter(ListEulasRequest::nextToken)).setter(ListEulasRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EULA_IDS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> eulaIds;
    private final String nextToken;

    private ListEulasRequest(BuilderImpl builder) {
        super(builder);
        this.eulaIds = builder.eulaIds;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEulaIds() {
        return this.eulaIds != null && !(this.eulaIds instanceof SdkAutoConstructList);
    }

    public final List<String> eulaIds() {
        return this.eulaIds;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEulaIds() ? this.eulaIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEulasRequest)) {
            return false;
        }
        ListEulasRequest other = (ListEulasRequest)((Object)obj);
        return this.hasEulaIds() == other.hasEulaIds() && Objects.equals(this.eulaIds(), other.eulaIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEulasRequest").add("EulaIds", this.hasEulaIds() ? this.eulaIds() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eulaIds": {
                return Optional.ofNullable(clazz.cast(this.eulaIds()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListEulasRequest, T> g) {
        return obj -> g.apply((ListEulasRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NimbleRequest.BuilderImpl
    implements Builder {
        private List<String> eulaIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEulasRequest model) {
            super(model);
            this.eulaIds(model.eulaIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getEulaIds() {
            if (this.eulaIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eulaIds;
        }

        public final void setEulaIds(Collection<String> eulaIds) {
            this.eulaIds = StringListCopier.copy(eulaIds);
        }

        @Override
        public final Builder eulaIds(Collection<String> eulaIds) {
            this.eulaIds = StringListCopier.copy(eulaIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eulaIds(String ... eulaIds) {
            this.eulaIds(Arrays.asList(eulaIds));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEulasRequest build() {
            return new ListEulasRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NimbleRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEulasRequest> {
        public Builder eulaIds(Collection<String> var1);

        public Builder eulaIds(String ... var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

