/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLoaderJobsRequest
extends NeptunedataRequest
implements ToCopyableBuilder<Builder, ListLoaderJobsRequest> {
    private static final SdkField<Integer> LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("limit").getter(ListLoaderJobsRequest.getter(ListLoaderJobsRequest::limit)).setter(ListLoaderJobsRequest.setter(Builder::limit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("limit").build()}).build();
    private static final SdkField<Boolean> INCLUDE_QUEUED_LOADS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeQueuedLoads").getter(ListLoaderJobsRequest.getter(ListLoaderJobsRequest::includeQueuedLoads)).setter(ListLoaderJobsRequest.setter(Builder::includeQueuedLoads)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeQueuedLoads").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_FIELD, INCLUDE_QUEUED_LOADS_FIELD));
    private final Integer limit;
    private final Boolean includeQueuedLoads;

    private ListLoaderJobsRequest(BuilderImpl builder) {
        super(builder);
        this.limit = builder.limit;
        this.includeQueuedLoads = builder.includeQueuedLoads;
    }

    public final Integer limit() {
        return this.limit;
    }

    public final Boolean includeQueuedLoads() {
        return this.includeQueuedLoads;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.limit());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeQueuedLoads());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLoaderJobsRequest)) {
            return false;
        }
        ListLoaderJobsRequest other = (ListLoaderJobsRequest)((Object)obj);
        return Objects.equals(this.limit(), other.limit()) && Objects.equals(this.includeQueuedLoads(), other.includeQueuedLoads());
    }

    public final String toString() {
        return ToString.builder((String)"ListLoaderJobsRequest").add("Limit", (Object)this.limit()).add("IncludeQueuedLoads", (Object)this.includeQueuedLoads()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "limit": {
                return Optional.ofNullable(clazz.cast(this.limit()));
            }
            case "includeQueuedLoads": {
                return Optional.ofNullable(clazz.cast(this.includeQueuedLoads()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLoaderJobsRequest, T> g) {
        return obj -> g.apply((ListLoaderJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataRequest.BuilderImpl
    implements Builder {
        private Integer limit;
        private Boolean includeQueuedLoads;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLoaderJobsRequest model) {
            super(model);
            this.limit(model.limit);
            this.includeQueuedLoads(model.includeQueuedLoads);
        }

        public final Integer getLimit() {
            return this.limit;
        }

        public final void setLimit(Integer limit) {
            this.limit = limit;
        }

        @Override
        public final Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public final Boolean getIncludeQueuedLoads() {
            return this.includeQueuedLoads;
        }

        public final void setIncludeQueuedLoads(Boolean includeQueuedLoads) {
            this.includeQueuedLoads = includeQueuedLoads;
        }

        @Override
        public final Builder includeQueuedLoads(Boolean includeQueuedLoads) {
            this.includeQueuedLoads = includeQueuedLoads;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLoaderJobsRequest build() {
            return new ListLoaderJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends NeptunedataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLoaderJobsRequest> {
        public Builder limit(Integer var1);

        public Builder includeQueuedLoads(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

