/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomModelTrainingParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomModelTrainingParameters> {
    private static final SdkField<String> SOURCE_S3_DIRECTORY_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceS3DirectoryPath").getter(CustomModelTrainingParameters.getter(CustomModelTrainingParameters::sourceS3DirectoryPath)).setter(CustomModelTrainingParameters.setter(Builder::sourceS3DirectoryPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceS3DirectoryPath").build()}).build();
    private static final SdkField<String> TRAINING_ENTRY_POINT_SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("trainingEntryPointScript").getter(CustomModelTrainingParameters.getter(CustomModelTrainingParameters::trainingEntryPointScript)).setter(CustomModelTrainingParameters.setter(Builder::trainingEntryPointScript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingEntryPointScript").build()}).build();
    private static final SdkField<String> TRANSFORM_ENTRY_POINT_SCRIPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transformEntryPointScript").getter(CustomModelTrainingParameters.getter(CustomModelTrainingParameters::transformEntryPointScript)).setter(CustomModelTrainingParameters.setter(Builder::transformEntryPointScript)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformEntryPointScript").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_S3_DIRECTORY_PATH_FIELD, TRAINING_ENTRY_POINT_SCRIPT_FIELD, TRANSFORM_ENTRY_POINT_SCRIPT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceS3DirectoryPath;
    private final String trainingEntryPointScript;
    private final String transformEntryPointScript;

    private CustomModelTrainingParameters(BuilderImpl builder) {
        this.sourceS3DirectoryPath = builder.sourceS3DirectoryPath;
        this.trainingEntryPointScript = builder.trainingEntryPointScript;
        this.transformEntryPointScript = builder.transformEntryPointScript;
    }

    public final String sourceS3DirectoryPath() {
        return this.sourceS3DirectoryPath;
    }

    public final String trainingEntryPointScript() {
        return this.trainingEntryPointScript;
    }

    public final String transformEntryPointScript() {
        return this.transformEntryPointScript;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceS3DirectoryPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingEntryPointScript());
        hashCode = 31 * hashCode + Objects.hashCode(this.transformEntryPointScript());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomModelTrainingParameters)) {
            return false;
        }
        CustomModelTrainingParameters other = (CustomModelTrainingParameters)obj;
        return Objects.equals(this.sourceS3DirectoryPath(), other.sourceS3DirectoryPath()) && Objects.equals(this.trainingEntryPointScript(), other.trainingEntryPointScript()) && Objects.equals(this.transformEntryPointScript(), other.transformEntryPointScript());
    }

    public final String toString() {
        return ToString.builder((String)"CustomModelTrainingParameters").add("SourceS3DirectoryPath", (Object)this.sourceS3DirectoryPath()).add("TrainingEntryPointScript", (Object)this.trainingEntryPointScript()).add("TransformEntryPointScript", (Object)this.transformEntryPointScript()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceS3DirectoryPath": {
                return Optional.ofNullable(clazz.cast(this.sourceS3DirectoryPath()));
            }
            case "trainingEntryPointScript": {
                return Optional.ofNullable(clazz.cast(this.trainingEntryPointScript()));
            }
            case "transformEntryPointScript": {
                return Optional.ofNullable(clazz.cast(this.transformEntryPointScript()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomModelTrainingParameters, T> g) {
        return obj -> g.apply((CustomModelTrainingParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceS3DirectoryPath;
        private String trainingEntryPointScript;
        private String transformEntryPointScript;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomModelTrainingParameters model) {
            this.sourceS3DirectoryPath(model.sourceS3DirectoryPath);
            this.trainingEntryPointScript(model.trainingEntryPointScript);
            this.transformEntryPointScript(model.transformEntryPointScript);
        }

        public final String getSourceS3DirectoryPath() {
            return this.sourceS3DirectoryPath;
        }

        public final void setSourceS3DirectoryPath(String sourceS3DirectoryPath) {
            this.sourceS3DirectoryPath = sourceS3DirectoryPath;
        }

        @Override
        public final Builder sourceS3DirectoryPath(String sourceS3DirectoryPath) {
            this.sourceS3DirectoryPath = sourceS3DirectoryPath;
            return this;
        }

        public final String getTrainingEntryPointScript() {
            return this.trainingEntryPointScript;
        }

        public final void setTrainingEntryPointScript(String trainingEntryPointScript) {
            this.trainingEntryPointScript = trainingEntryPointScript;
        }

        @Override
        public final Builder trainingEntryPointScript(String trainingEntryPointScript) {
            this.trainingEntryPointScript = trainingEntryPointScript;
            return this;
        }

        public final String getTransformEntryPointScript() {
            return this.transformEntryPointScript;
        }

        public final void setTransformEntryPointScript(String transformEntryPointScript) {
            this.transformEntryPointScript = transformEntryPointScript;
        }

        @Override
        public final Builder transformEntryPointScript(String transformEntryPointScript) {
            this.transformEntryPointScript = transformEntryPointScript;
            return this;
        }

        public CustomModelTrainingParameters build() {
            return new CustomModelTrainingParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomModelTrainingParameters> {
        public Builder sourceS3DirectoryPath(String var1);

        public Builder trainingEntryPointScript(String var1);

        public Builder transformEntryPointScript(String var1);
    }
}

