/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Comparator {
    LESS_THAN("LessThan"),
    LESS_THAN_OR_EQUAL_TO("LessThanOrEqualTo"),
    GREATER_THAN("GreaterThan"),
    GREATER_THAN_OR_EQUAL_TO("GreaterThanOrEqualTo"),
    EQUAL_TO("EqualTo"),
    NOT_EQUAL_TO("NotEqualTo"),
    EXISTS("Exists"),
    DOES_NOT_EXIST("DoesNotExist"),
    IN("In"),
    NOT_IN("NotIn"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Comparator> VALUE_MAP;
    private final String value;

    private Comparator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Comparator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Comparator> knownValues() {
        EnumSet<Comparator> knownValues = EnumSet.allOf(Comparator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Comparator.class, Comparator::toString);
    }
}

