/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mturk.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateHitReviewStatusRequest extends MTurkRequest implements
        ToCopyableBuilder<UpdateHitReviewStatusRequest.Builder, UpdateHitReviewStatusRequest> {
    private static final SdkField<String> HIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HITId")
            .getter(getter(UpdateHitReviewStatusRequest::hitId)).setter(setter(Builder::hitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HITId").build()).build();

    private static final SdkField<Boolean> REVERT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Revert").getter(getter(UpdateHitReviewStatusRequest::revert)).setter(setter(Builder::revert))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revert").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HIT_ID_FIELD, REVERT_FIELD));

    private final String hitId;

    private final Boolean revert;

    private UpdateHitReviewStatusRequest(BuilderImpl builder) {
        super(builder);
        this.hitId = builder.hitId;
        this.revert = builder.revert;
    }

    /**
     * <p>
     * The ID of the HIT to update.
     * </p>
     * 
     * @return The ID of the HIT to update.
     */
    public final String hitId() {
        return hitId;
    }

    /**
     * <p>
     * Specifies how to update the HIT status. Default is <code>False</code>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Setting this to false will only transition a HIT from <code>Reviewable</code> to <code>Reviewing</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Setting this to true will only transition a HIT from <code>Reviewing</code> to <code>Reviewable</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies how to update the HIT status. Default is <code>False</code>. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Setting this to false will only transition a HIT from <code>Reviewable</code> to <code>Reviewing</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Setting this to true will only transition a HIT from <code>Reviewing</code> to <code>Reviewable</code>
     *         </p>
     *         </li>
     */
    public final Boolean revert() {
        return revert;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hitId());
        hashCode = 31 * hashCode + Objects.hashCode(revert());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHitReviewStatusRequest)) {
            return false;
        }
        UpdateHitReviewStatusRequest other = (UpdateHitReviewStatusRequest) obj;
        return Objects.equals(hitId(), other.hitId()) && Objects.equals(revert(), other.revert());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateHitReviewStatusRequest").add("HITId", hitId()).add("Revert", revert()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HITId":
            return Optional.ofNullable(clazz.cast(hitId()));
        case "Revert":
            return Optional.ofNullable(clazz.cast(revert()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateHitReviewStatusRequest, T> g) {
        return obj -> g.apply((UpdateHitReviewStatusRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MTurkRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateHitReviewStatusRequest> {
        /**
         * <p>
         * The ID of the HIT to update.
         * </p>
         * 
         * @param hitId
         *        The ID of the HIT to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hitId(String hitId);

        /**
         * <p>
         * Specifies how to update the HIT status. Default is <code>False</code>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Setting this to false will only transition a HIT from <code>Reviewable</code> to <code>Reviewing</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Setting this to true will only transition a HIT from <code>Reviewing</code> to <code>Reviewable</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param revert
         *        Specifies how to update the HIT status. Default is <code>False</code>. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Setting this to false will only transition a HIT from <code>Reviewable</code> to
         *        <code>Reviewing</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Setting this to true will only transition a HIT from <code>Reviewing</code> to <code>Reviewable</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revert(Boolean revert);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MTurkRequest.BuilderImpl implements Builder {
        private String hitId;

        private Boolean revert;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHitReviewStatusRequest model) {
            super(model);
            hitId(model.hitId);
            revert(model.revert);
        }

        public final String getHitId() {
            return hitId;
        }

        public final void setHitId(String hitId) {
            this.hitId = hitId;
        }

        @Override
        public final Builder hitId(String hitId) {
            this.hitId = hitId;
            return this;
        }

        public final Boolean getRevert() {
            return revert;
        }

        public final void setRevert(Boolean revert) {
            this.revert = revert;
        }

        @Override
        public final Builder revert(Boolean revert) {
            this.revert = revert;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHitReviewStatusRequest build() {
            return new UpdateHitReviewStatusRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
