/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mturk.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mturk.model.Locale;
import software.amazon.awssdk.services.mturk.model.QualificationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Qualification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Qualification> {
    private static final SdkField<String> QUALIFICATION_TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QualificationTypeId").getter(Qualification.getter(Qualification::qualificationTypeId)).setter(Qualification.setter(Builder::qualificationTypeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QualificationTypeId").build()}).build();
    private static final SdkField<String> WORKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WorkerId").getter(Qualification.getter(Qualification::workerId)).setter(Qualification.setter(Builder::workerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkerId").build()}).build();
    private static final SdkField<Instant> GRANT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("GrantTime").getter(Qualification.getter(Qualification::grantTime)).setter(Qualification.setter(Builder::grantTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantTime").build()}).build();
    private static final SdkField<Integer> INTEGER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("IntegerValue").getter(Qualification.getter(Qualification::integerValue)).setter(Qualification.setter(Builder::integerValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntegerValue").build()}).build();
    private static final SdkField<Locale> LOCALE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LocaleValue").getter(Qualification.getter(Qualification::localeValue)).setter(Qualification.setter(Builder::localeValue)).constructor(Locale::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocaleValue").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Qualification.getter(Qualification::statusAsString)).setter(Qualification.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUALIFICATION_TYPE_ID_FIELD, WORKER_ID_FIELD, GRANT_TIME_FIELD, INTEGER_VALUE_FIELD, LOCALE_VALUE_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String qualificationTypeId;
    private final String workerId;
    private final Instant grantTime;
    private final Integer integerValue;
    private final Locale localeValue;
    private final String status;

    private Qualification(BuilderImpl builder) {
        this.qualificationTypeId = builder.qualificationTypeId;
        this.workerId = builder.workerId;
        this.grantTime = builder.grantTime;
        this.integerValue = builder.integerValue;
        this.localeValue = builder.localeValue;
        this.status = builder.status;
    }

    public final String qualificationTypeId() {
        return this.qualificationTypeId;
    }

    public final String workerId() {
        return this.workerId;
    }

    public final Instant grantTime() {
        return this.grantTime;
    }

    public final Integer integerValue() {
        return this.integerValue;
    }

    public final Locale localeValue() {
        return this.localeValue;
    }

    public final QualificationStatus status() {
        return QualificationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.qualificationTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.workerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Qualification)) {
            return false;
        }
        Qualification other = (Qualification)obj;
        return Objects.equals(this.qualificationTypeId(), other.qualificationTypeId()) && Objects.equals(this.workerId(), other.workerId()) && Objects.equals(this.grantTime(), other.grantTime()) && Objects.equals(this.integerValue(), other.integerValue()) && Objects.equals(this.localeValue(), other.localeValue()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Qualification").add("QualificationTypeId", (Object)this.qualificationTypeId()).add("WorkerId", (Object)this.workerId()).add("GrantTime", (Object)this.grantTime()).add("IntegerValue", (Object)this.integerValue()).add("LocaleValue", (Object)this.localeValue()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QualificationTypeId": {
                return Optional.ofNullable(clazz.cast(this.qualificationTypeId()));
            }
            case "WorkerId": {
                return Optional.ofNullable(clazz.cast(this.workerId()));
            }
            case "GrantTime": {
                return Optional.ofNullable(clazz.cast(this.grantTime()));
            }
            case "IntegerValue": {
                return Optional.ofNullable(clazz.cast(this.integerValue()));
            }
            case "LocaleValue": {
                return Optional.ofNullable(clazz.cast(this.localeValue()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Qualification, T> g) {
        return obj -> g.apply((Qualification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String qualificationTypeId;
        private String workerId;
        private Instant grantTime;
        private Integer integerValue;
        private Locale localeValue;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(Qualification model) {
            this.qualificationTypeId(model.qualificationTypeId);
            this.workerId(model.workerId);
            this.grantTime(model.grantTime);
            this.integerValue(model.integerValue);
            this.localeValue(model.localeValue);
            this.status(model.status);
        }

        public final String getQualificationTypeId() {
            return this.qualificationTypeId;
        }

        public final void setQualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
        }

        @Override
        public final Builder qualificationTypeId(String qualificationTypeId) {
            this.qualificationTypeId = qualificationTypeId;
            return this;
        }

        public final String getWorkerId() {
            return this.workerId;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final Instant getGrantTime() {
            return this.grantTime;
        }

        public final void setGrantTime(Instant grantTime) {
            this.grantTime = grantTime;
        }

        @Override
        public final Builder grantTime(Instant grantTime) {
            this.grantTime = grantTime;
            return this;
        }

        public final Integer getIntegerValue() {
            return this.integerValue;
        }

        public final void setIntegerValue(Integer integerValue) {
            this.integerValue = integerValue;
        }

        @Override
        public final Builder integerValue(Integer integerValue) {
            this.integerValue = integerValue;
            return this;
        }

        public final Locale.Builder getLocaleValue() {
            return this.localeValue != null ? this.localeValue.toBuilder() : null;
        }

        public final void setLocaleValue(Locale.BuilderImpl localeValue) {
            this.localeValue = localeValue != null ? localeValue.build() : null;
        }

        @Override
        public final Builder localeValue(Locale localeValue) {
            this.localeValue = localeValue;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QualificationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public Qualification build() {
            return new Qualification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Qualification> {
        public Builder qualificationTypeId(String var1);

        public Builder workerId(String var1);

        public Builder grantTime(Instant var1);

        public Builder integerValue(Integer var1);

        public Builder localeValue(Locale var1);

        default public Builder localeValue(Consumer<Locale.Builder> localeValue) {
            return this.localeValue((Locale)((Locale.Builder)Locale.builder().applyMutation(localeValue)).build());
        }

        public Builder status(String var1);

        public Builder status(QualificationStatus var1);
    }
}

