/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mq.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BrokerState {
    CREATION_IN_PROGRESS("CREATION_IN_PROGRESS"),
    CREATION_FAILED("CREATION_FAILED"),
    DELETION_IN_PROGRESS("DELETION_IN_PROGRESS"),
    RUNNING("RUNNING"),
    REBOOT_IN_PROGRESS("REBOOT_IN_PROGRESS"),
    CRITICAL_ACTION_REQUIRED("CRITICAL_ACTION_REQUIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BrokerState> VALUE_MAP;
    private final String value;

    private BrokerState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BrokerState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BrokerState> knownValues() {
        EnumSet<BrokerState> knownValues = EnumSet.allOf(BrokerState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BrokerState.class, BrokerState::toString);
    }
}

