/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The list of information about logs to be enabled for the specified broker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Logs implements SdkPojo, Serializable, ToCopyableBuilder<Logs.Builder, Logs> {
    private static final SdkField<Boolean> AUDIT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Audit")
            .getter(getter(Logs::audit)).setter(setter(Builder::audit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audit").build()).build();

    private static final SdkField<Boolean> GENERAL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("General").getter(getter(Logs::general)).setter(setter(Builder::general))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("general").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIT_FIELD, GENERAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean audit;

    private final Boolean general;

    private Logs(BuilderImpl builder) {
        this.audit = builder.audit;
        this.general = builder.general;
    }

    /**
     * <p>
     * Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged. Does
     * not apply to RabbitMQ brokers.
     * </p>
     * 
     * @return Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.
     *         Does not apply to RabbitMQ brokers.
     */
    public final Boolean audit() {
        return audit;
    }

    /**
     * <p>
     * Enables general logging.
     * </p>
     * 
     * @return Enables general logging.
     */
    public final Boolean general() {
        return general;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audit());
        hashCode = 31 * hashCode + Objects.hashCode(general());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Logs)) {
            return false;
        }
        Logs other = (Logs) obj;
        return Objects.equals(audit(), other.audit()) && Objects.equals(general(), other.general());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Logs").add("Audit", audit()).add("General", general()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Audit":
            return Optional.ofNullable(clazz.cast(audit()));
        case "General":
            return Optional.ofNullable(clazz.cast(general()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Logs, T> g) {
        return obj -> g.apply((Logs) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Logs> {
        /**
         * <p>
         * Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is logged.
         * Does not apply to RabbitMQ brokers.
         * </p>
         * 
         * @param audit
         *        Enables audit logging. Every user management action made using JMX or the ActiveMQ Web Console is
         *        logged. Does not apply to RabbitMQ brokers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audit(Boolean audit);

        /**
         * <p>
         * Enables general logging.
         * </p>
         * 
         * @param general
         *        Enables general logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder general(Boolean general);
    }

    static final class BuilderImpl implements Builder {
        private Boolean audit;

        private Boolean general;

        private BuilderImpl() {
        }

        private BuilderImpl(Logs model) {
            audit(model.audit);
            general(model.general);
        }

        public final Boolean getAudit() {
            return audit;
        }

        public final void setAudit(Boolean audit) {
            this.audit = audit;
        }

        @Override
        public final Builder audit(Boolean audit) {
            this.audit = audit;
            return this;
        }

        public final Boolean getGeneral() {
            return general;
        }

        public final void setGeneral(Boolean general) {
            this.general = general;
        }

        @Override
        public final Builder general(Boolean general) {
            this.general = general;
            return this;
        }

        @Override
        public Logs build() {
            return new Logs(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
