/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.migrationhubstrategy.model.ApplicationComponentDetail;
import software.amazon.awssdk.services.migrationhubstrategy.model.AssociatedApplication;
import software.amazon.awssdk.services.migrationhubstrategy.model.AssociatedApplicationsCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.AssociatedServerIDsCopier;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetApplicationComponentDetailsResponse
extends MigrationHubStrategyResponse
implements ToCopyableBuilder<Builder, GetApplicationComponentDetailsResponse> {
    private static final SdkField<ApplicationComponentDetail> APPLICATION_COMPONENT_DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("applicationComponentDetail").getter(GetApplicationComponentDetailsResponse.getter(GetApplicationComponentDetailsResponse::applicationComponentDetail)).setter(GetApplicationComponentDetailsResponse.setter(Builder::applicationComponentDetail)).constructor(ApplicationComponentDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationComponentDetail").build()}).build();
    private static final SdkField<List<AssociatedApplication>> ASSOCIATED_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedApplications").getter(GetApplicationComponentDetailsResponse.getter(GetApplicationComponentDetailsResponse::associatedApplications)).setter(GetApplicationComponentDetailsResponse.setter(Builder::associatedApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedApplications").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssociatedApplication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ASSOCIATED_SERVER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("associatedServerIds").getter(GetApplicationComponentDetailsResponse.getter(GetApplicationComponentDetailsResponse::associatedServerIds)).setter(GetApplicationComponentDetailsResponse.setter(Builder::associatedServerIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedServerIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MORE_APPLICATION_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("moreApplicationResource").getter(GetApplicationComponentDetailsResponse.getter(GetApplicationComponentDetailsResponse::moreApplicationResource)).setter(GetApplicationComponentDetailsResponse.setter(Builder::moreApplicationResource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("moreApplicationResource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_COMPONENT_DETAIL_FIELD, ASSOCIATED_APPLICATIONS_FIELD, ASSOCIATED_SERVER_IDS_FIELD, MORE_APPLICATION_RESOURCE_FIELD));
    private final ApplicationComponentDetail applicationComponentDetail;
    private final List<AssociatedApplication> associatedApplications;
    private final List<String> associatedServerIds;
    private final Boolean moreApplicationResource;

    private GetApplicationComponentDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationComponentDetail = builder.applicationComponentDetail;
        this.associatedApplications = builder.associatedApplications;
        this.associatedServerIds = builder.associatedServerIds;
        this.moreApplicationResource = builder.moreApplicationResource;
    }

    public final ApplicationComponentDetail applicationComponentDetail() {
        return this.applicationComponentDetail;
    }

    public final boolean hasAssociatedApplications() {
        return this.associatedApplications != null && !(this.associatedApplications instanceof SdkAutoConstructList);
    }

    public final List<AssociatedApplication> associatedApplications() {
        return this.associatedApplications;
    }

    public final boolean hasAssociatedServerIds() {
        return this.associatedServerIds != null && !(this.associatedServerIds instanceof SdkAutoConstructList);
    }

    public final List<String> associatedServerIds() {
        return this.associatedServerIds;
    }

    public final Boolean moreApplicationResource() {
        return this.moreApplicationResource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationComponentDetail());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedApplications() ? this.associatedApplications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociatedServerIds() ? this.associatedServerIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.moreApplicationResource());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetApplicationComponentDetailsResponse)) {
            return false;
        }
        GetApplicationComponentDetailsResponse other = (GetApplicationComponentDetailsResponse)((Object)obj);
        return Objects.equals(this.applicationComponentDetail(), other.applicationComponentDetail()) && this.hasAssociatedApplications() == other.hasAssociatedApplications() && Objects.equals(this.associatedApplications(), other.associatedApplications()) && this.hasAssociatedServerIds() == other.hasAssociatedServerIds() && Objects.equals(this.associatedServerIds(), other.associatedServerIds()) && Objects.equals(this.moreApplicationResource(), other.moreApplicationResource());
    }

    public final String toString() {
        return ToString.builder((String)"GetApplicationComponentDetailsResponse").add("ApplicationComponentDetail", (Object)this.applicationComponentDetail()).add("AssociatedApplications", this.hasAssociatedApplications() ? this.associatedApplications() : null).add("AssociatedServerIds", this.hasAssociatedServerIds() ? this.associatedServerIds() : null).add("MoreApplicationResource", (Object)this.moreApplicationResource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationComponentDetail": {
                return Optional.ofNullable(clazz.cast(this.applicationComponentDetail()));
            }
            case "associatedApplications": {
                return Optional.ofNullable(clazz.cast(this.associatedApplications()));
            }
            case "associatedServerIds": {
                return Optional.ofNullable(clazz.cast(this.associatedServerIds()));
            }
            case "moreApplicationResource": {
                return Optional.ofNullable(clazz.cast(this.moreApplicationResource()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetApplicationComponentDetailsResponse, T> g) {
        return obj -> g.apply((GetApplicationComponentDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MigrationHubStrategyResponse.BuilderImpl
    implements Builder {
        private ApplicationComponentDetail applicationComponentDetail;
        private List<AssociatedApplication> associatedApplications = DefaultSdkAutoConstructList.getInstance();
        private List<String> associatedServerIds = DefaultSdkAutoConstructList.getInstance();
        private Boolean moreApplicationResource;

        private BuilderImpl() {
        }

        private BuilderImpl(GetApplicationComponentDetailsResponse model) {
            super(model);
            this.applicationComponentDetail(model.applicationComponentDetail);
            this.associatedApplications(model.associatedApplications);
            this.associatedServerIds(model.associatedServerIds);
            this.moreApplicationResource(model.moreApplicationResource);
        }

        public final ApplicationComponentDetail.Builder getApplicationComponentDetail() {
            return this.applicationComponentDetail != null ? this.applicationComponentDetail.toBuilder() : null;
        }

        public final void setApplicationComponentDetail(ApplicationComponentDetail.BuilderImpl applicationComponentDetail) {
            this.applicationComponentDetail = applicationComponentDetail != null ? applicationComponentDetail.build() : null;
        }

        @Override
        public final Builder applicationComponentDetail(ApplicationComponentDetail applicationComponentDetail) {
            this.applicationComponentDetail = applicationComponentDetail;
            return this;
        }

        public final List<AssociatedApplication.Builder> getAssociatedApplications() {
            List<AssociatedApplication.Builder> result = AssociatedApplicationsCopier.copyToBuilder(this.associatedApplications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedApplications(Collection<AssociatedApplication.BuilderImpl> associatedApplications) {
            this.associatedApplications = AssociatedApplicationsCopier.copyFromBuilder(associatedApplications);
        }

        @Override
        public final Builder associatedApplications(Collection<AssociatedApplication> associatedApplications) {
            this.associatedApplications = AssociatedApplicationsCopier.copy(associatedApplications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedApplications(AssociatedApplication ... associatedApplications) {
            this.associatedApplications(Arrays.asList(associatedApplications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedApplications(Consumer<AssociatedApplication.Builder> ... associatedApplications) {
            this.associatedApplications(Stream.of(associatedApplications).map(c -> (AssociatedApplication)((AssociatedApplication.Builder)AssociatedApplication.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAssociatedServerIds() {
            if (this.associatedServerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.associatedServerIds;
        }

        public final void setAssociatedServerIds(Collection<String> associatedServerIds) {
            this.associatedServerIds = AssociatedServerIDsCopier.copy(associatedServerIds);
        }

        @Override
        public final Builder associatedServerIds(Collection<String> associatedServerIds) {
            this.associatedServerIds = AssociatedServerIDsCopier.copy(associatedServerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedServerIds(String ... associatedServerIds) {
            this.associatedServerIds(Arrays.asList(associatedServerIds));
            return this;
        }

        public final Boolean getMoreApplicationResource() {
            return this.moreApplicationResource;
        }

        public final void setMoreApplicationResource(Boolean moreApplicationResource) {
            this.moreApplicationResource = moreApplicationResource;
        }

        @Override
        public final Builder moreApplicationResource(Boolean moreApplicationResource) {
            this.moreApplicationResource = moreApplicationResource;
            return this;
        }

        @Override
        public GetApplicationComponentDetailsResponse build() {
            return new GetApplicationComponentDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MigrationHubStrategyResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetApplicationComponentDetailsResponse> {
        public Builder applicationComponentDetail(ApplicationComponentDetail var1);

        default public Builder applicationComponentDetail(Consumer<ApplicationComponentDetail.Builder> applicationComponentDetail) {
            return this.applicationComponentDetail((ApplicationComponentDetail)((ApplicationComponentDetail.Builder)ApplicationComponentDetail.builder().applyMutation(applicationComponentDetail)).build());
        }

        public Builder associatedApplications(Collection<AssociatedApplication> var1);

        public Builder associatedApplications(AssociatedApplication ... var1);

        public Builder associatedApplications(Consumer<AssociatedApplication.Builder> ... var1);

        public Builder associatedServerIds(Collection<String> var1);

        public Builder associatedServerIds(String ... var1);

        public Builder moreApplicationResource(Boolean var1);
    }
}

