/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.migrationhubstrategy.MigrationHubStrategyClient;
import software.amazon.awssdk.services.migrationhubstrategy.MigrationHubStrategyServiceClientConfiguration;
import software.amazon.awssdk.services.migrationhubstrategy.internal.MigrationHubStrategyServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.migrationhubstrategy.model.AccessDeniedException;
import software.amazon.awssdk.services.migrationhubstrategy.model.ConflictException;
import software.amazon.awssdk.services.migrationhubstrategy.model.DependencyException;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetApplicationComponentDetailsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetApplicationComponentDetailsResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetApplicationComponentStrategiesRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetApplicationComponentStrategiesResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetAssessmentRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetAssessmentResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetImportFileTaskRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetImportFileTaskResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetLatestAssessmentIdRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetLatestAssessmentIdResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetPortfolioPreferencesRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetPortfolioPreferencesResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetPortfolioSummaryRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetPortfolioSummaryResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetRecommendationReportDetailsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetRecommendationReportDetailsResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetServerDetailsResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetServerStrategiesRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.GetServerStrategiesResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.InternalServerException;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListAnalyzableServersResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListApplicationComponentsResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListCollectorsResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListImportFileTaskResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListServersRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.ListServersResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.MigrationHubStrategyException;
import software.amazon.awssdk.services.migrationhubstrategy.model.PutPortfolioPreferencesRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.PutPortfolioPreferencesResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ResourceNotFoundException;
import software.amazon.awssdk.services.migrationhubstrategy.model.ServiceLinkedRoleLockClientException;
import software.amazon.awssdk.services.migrationhubstrategy.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartAssessmentRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartAssessmentResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartImportFileTaskRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartImportFileTaskResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartRecommendationReportGenerationRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.StartRecommendationReportGenerationResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.StopAssessmentRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.StopAssessmentResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ThrottlingException;
import software.amazon.awssdk.services.migrationhubstrategy.model.UpdateApplicationComponentConfigRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.UpdateApplicationComponentConfigResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.UpdateServerConfigRequest;
import software.amazon.awssdk.services.migrationhubstrategy.model.UpdateServerConfigResponse;
import software.amazon.awssdk.services.migrationhubstrategy.model.ValidationException;
import software.amazon.awssdk.services.migrationhubstrategy.transform.GetApplicationComponentDetailsRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.GetApplicationComponentStrategiesRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.GetAssessmentRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.GetImportFileTaskRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.GetLatestAssessmentIdRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.GetPortfolioPreferencesRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.GetPortfolioSummaryRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.GetRecommendationReportDetailsRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.GetServerDetailsRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.GetServerStrategiesRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.ListAnalyzableServersRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.ListApplicationComponentsRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.ListCollectorsRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.ListImportFileTaskRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.ListServersRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.PutPortfolioPreferencesRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.StartAssessmentRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.StartImportFileTaskRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.StartRecommendationReportGenerationRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.StopAssessmentRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.UpdateApplicationComponentConfigRequestMarshaller;
import software.amazon.awssdk.services.migrationhubstrategy.transform.UpdateServerConfigRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultMigrationHubStrategyClient
implements MigrationHubStrategyClient {
    private static final Logger log = Logger.loggerFor(DefaultMigrationHubStrategyClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultMigrationHubStrategyClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetApplicationComponentDetailsResponse getApplicationComponentDetails(GetApplicationComponentDetailsRequest getApplicationComponentDetailsRequest) throws ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApplicationComponentDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getApplicationComponentDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, getApplicationComponentDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApplicationComponentDetails");
            GetApplicationComponentDetailsResponse getApplicationComponentDetailsResponse = (GetApplicationComponentDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApplicationComponentDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getApplicationComponentDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetApplicationComponentDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getApplicationComponentDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$getApplicationComponentDetails$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetApplicationComponentStrategiesResponse getApplicationComponentStrategies(GetApplicationComponentStrategiesRequest getApplicationComponentStrategiesRequest) throws ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApplicationComponentStrategiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getApplicationComponentStrategiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, getApplicationComponentStrategiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApplicationComponentStrategies");
            GetApplicationComponentStrategiesResponse getApplicationComponentStrategiesResponse = (GetApplicationComponentStrategiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApplicationComponentStrategies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getApplicationComponentStrategiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetApplicationComponentStrategiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getApplicationComponentStrategiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$getApplicationComponentStrategies$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAssessmentResponse getAssessment(GetAssessmentRequest getAssessmentRequest) throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAssessmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAssessmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, getAssessmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAssessment");
            GetAssessmentResponse getAssessmentResponse = (GetAssessmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAssessment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAssessmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAssessmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAssessmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$getAssessment$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetImportFileTaskResponse getImportFileTask(GetImportFileTaskRequest getImportFileTaskRequest) throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetImportFileTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getImportFileTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, getImportFileTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetImportFileTask");
            GetImportFileTaskResponse getImportFileTaskResponse = (GetImportFileTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetImportFileTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getImportFileTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetImportFileTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getImportFileTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$getImportFileTask$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLatestAssessmentIdResponse getLatestAssessmentId(GetLatestAssessmentIdRequest getLatestAssessmentIdRequest) throws DependencyException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetLatestAssessmentIdResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getLatestAssessmentIdRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, getLatestAssessmentIdRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetLatestAssessmentId");
            GetLatestAssessmentIdResponse getLatestAssessmentIdResponse = (GetLatestAssessmentIdResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetLatestAssessmentId").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getLatestAssessmentIdRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetLatestAssessmentIdRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getLatestAssessmentIdResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$getLatestAssessmentId$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPortfolioPreferencesResponse getPortfolioPreferences(GetPortfolioPreferencesRequest getPortfolioPreferencesRequest) throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPortfolioPreferencesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPortfolioPreferencesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, getPortfolioPreferencesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPortfolioPreferences");
            GetPortfolioPreferencesResponse getPortfolioPreferencesResponse = (GetPortfolioPreferencesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPortfolioPreferences").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPortfolioPreferencesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPortfolioPreferencesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPortfolioPreferencesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$getPortfolioPreferences$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPortfolioSummaryResponse getPortfolioSummary(GetPortfolioSummaryRequest getPortfolioSummaryRequest) throws AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPortfolioSummaryResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getPortfolioSummaryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, getPortfolioSummaryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetPortfolioSummary");
            GetPortfolioSummaryResponse getPortfolioSummaryResponse = (GetPortfolioSummaryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPortfolioSummary").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getPortfolioSummaryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetPortfolioSummaryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getPortfolioSummaryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$getPortfolioSummary$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRecommendationReportDetailsResponse getRecommendationReportDetails(GetRecommendationReportDetailsRequest getRecommendationReportDetailsRequest) throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRecommendationReportDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRecommendationReportDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, getRecommendationReportDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRecommendationReportDetails");
            GetRecommendationReportDetailsResponse getRecommendationReportDetailsResponse = (GetRecommendationReportDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRecommendationReportDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRecommendationReportDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRecommendationReportDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRecommendationReportDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$getRecommendationReportDetails$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetServerDetailsResponse getServerDetails(GetServerDetailsRequest getServerDetailsRequest) throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServerDetailsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getServerDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, getServerDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServerDetails");
            GetServerDetailsResponse getServerDetailsResponse = (GetServerDetailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServerDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getServerDetailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetServerDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getServerDetailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$getServerDetails$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetServerStrategiesResponse getServerStrategies(GetServerStrategiesRequest getServerStrategiesRequest) throws ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetServerStrategiesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getServerStrategiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, getServerStrategiesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetServerStrategies");
            GetServerStrategiesResponse getServerStrategiesResponse = (GetServerStrategiesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetServerStrategies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getServerStrategiesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetServerStrategiesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getServerStrategiesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$getServerStrategies$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAnalyzableServersResponse listAnalyzableServers(ListAnalyzableServersRequest listAnalyzableServersRequest) throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAnalyzableServersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAnalyzableServersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, listAnalyzableServersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAnalyzableServers");
            ListAnalyzableServersResponse listAnalyzableServersResponse = (ListAnalyzableServersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAnalyzableServers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAnalyzableServersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAnalyzableServersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAnalyzableServersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$listAnalyzableServers$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationComponentsResponse listApplicationComponents(ListApplicationComponentsRequest listApplicationComponentsRequest) throws AccessDeniedException, ServiceLinkedRoleLockClientException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationComponentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listApplicationComponentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, listApplicationComponentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListApplicationComponents");
            ListApplicationComponentsResponse listApplicationComponentsResponse = (ListApplicationComponentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationComponents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listApplicationComponentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListApplicationComponentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listApplicationComponentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$listApplicationComponents$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCollectorsResponse listCollectors(ListCollectorsRequest listCollectorsRequest) throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCollectorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCollectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, listCollectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCollectors");
            ListCollectorsResponse listCollectorsResponse = (ListCollectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCollectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listCollectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListCollectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listCollectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$listCollectors$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListImportFileTaskResponse listImportFileTask(ListImportFileTaskRequest listImportFileTaskRequest) throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListImportFileTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listImportFileTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, listImportFileTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListImportFileTask");
            ListImportFileTaskResponse listImportFileTaskResponse = (ListImportFileTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListImportFileTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listImportFileTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListImportFileTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listImportFileTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$listImportFileTask$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListServersResponse listServers(ListServersRequest listServersRequest) throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListServersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listServersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, listServersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListServers");
            ListServersResponse listServersResponse = (ListServersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListServers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listServersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListServersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listServersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$listServers$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPortfolioPreferencesResponse putPortfolioPreferences(PutPortfolioPreferencesRequest putPortfolioPreferencesRequest) throws AccessDeniedException, ThrottlingException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutPortfolioPreferencesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putPortfolioPreferencesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, putPortfolioPreferencesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutPortfolioPreferences");
            PutPortfolioPreferencesResponse putPortfolioPreferencesResponse = (PutPortfolioPreferencesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPortfolioPreferences").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putPortfolioPreferencesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutPortfolioPreferencesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putPortfolioPreferencesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$putPortfolioPreferences$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartAssessmentResponse startAssessment(StartAssessmentRequest startAssessmentRequest) throws AccessDeniedException, ThrottlingException, ServiceQuotaExceededException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartAssessmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startAssessmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, startAssessmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartAssessment");
            StartAssessmentResponse startAssessmentResponse = (StartAssessmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartAssessment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startAssessmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartAssessmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startAssessmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$startAssessment$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartImportFileTaskResponse startImportFileTask(StartImportFileTaskRequest startImportFileTaskRequest) throws AccessDeniedException, ThrottlingException, ServiceQuotaExceededException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartImportFileTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startImportFileTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, startImportFileTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartImportFileTask");
            StartImportFileTaskResponse startImportFileTaskResponse = (StartImportFileTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartImportFileTask").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startImportFileTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartImportFileTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startImportFileTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$startImportFileTask$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartRecommendationReportGenerationResponse startRecommendationReportGeneration(StartRecommendationReportGenerationRequest startRecommendationReportGenerationRequest) throws AccessDeniedException, ThrottlingException, ValidationException, ConflictException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartRecommendationReportGenerationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startRecommendationReportGenerationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, startRecommendationReportGenerationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartRecommendationReportGeneration");
            StartRecommendationReportGenerationResponse startRecommendationReportGenerationResponse = (StartRecommendationReportGenerationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartRecommendationReportGeneration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startRecommendationReportGenerationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartRecommendationReportGenerationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startRecommendationReportGenerationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$startRecommendationReportGeneration$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StopAssessmentResponse stopAssessment(StopAssessmentRequest stopAssessmentRequest) throws AccessDeniedException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopAssessmentResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopAssessmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, stopAssessmentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopAssessment");
            StopAssessmentResponse stopAssessmentResponse = (StopAssessmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopAssessment").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)stopAssessmentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StopAssessmentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return stopAssessmentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$stopAssessment$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApplicationComponentConfigResponse updateApplicationComponentConfig(UpdateApplicationComponentConfigRequest updateApplicationComponentConfigRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApplicationComponentConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateApplicationComponentConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, updateApplicationComponentConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateApplicationComponentConfig");
            UpdateApplicationComponentConfigResponse updateApplicationComponentConfigResponse = (UpdateApplicationComponentConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplicationComponentConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateApplicationComponentConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateApplicationComponentConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateApplicationComponentConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$updateApplicationComponentConfig$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServerConfigResponse updateServerConfig(UpdateServerConfigRequest updateServerConfigRequest) throws ResourceNotFoundException, ThrottlingException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, MigrationHubStrategyException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateServerConfigResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateServerConfigRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultMigrationHubStrategyClient.resolveMetricPublishers(clientConfiguration, updateServerConfigRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"MigrationHubStrategy");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateServerConfig");
            UpdateServerConfigResponse updateServerConfigResponse = (UpdateServerConfigResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServerConfig").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateServerConfigRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateServerConfigRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateServerConfigResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultMigrationHubStrategyClient.lambda$updateServerConfig$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "migrationhub-strategy";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        MigrationHubStrategyServiceClientConfigurationBuilder serviceConfigBuilder = new MigrationHubStrategyServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(MigrationHubStrategyException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DependencyException").exceptionBuilderSupplier(DependencyException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceLinkedRoleLockClientException").exceptionBuilderSupplier(ServiceLinkedRoleLockClientException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final MigrationHubStrategyServiceClientConfiguration serviceClientConfiguration() {
        return new MigrationHubStrategyServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateServerConfig$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateApplicationComponentConfig$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopAssessment$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startRecommendationReportGeneration$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startImportFileTask$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startAssessment$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putPortfolioPreferences$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listServers$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listImportFileTask$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCollectors$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listApplicationComponents$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAnalyzableServers$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServerStrategies$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getServerDetails$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRecommendationReportDetails$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPortfolioSummary$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getPortfolioPreferences$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getLatestAssessmentId$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getImportFileTask$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAssessment$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApplicationComponentStrategies$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApplicationComponentDetails$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

