/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TargetDatabaseEngine {
    NONE_SPECIFIED("None specified"),
    AMAZON_AURORA("Amazon Aurora"),
    AWS_POSTGRE_SQL("AWS PostgreSQL"),
    MY_SQL("MySQL"),
    MICROSOFT_SQL_SERVER("Microsoft SQL Server"),
    ORACLE_DATABASE("Oracle Database"),
    MARIA_DB("MariaDB"),
    SAP("SAP"),
    DB2_LUW("Db2 LUW"),
    MONGO_DB("MongoDB"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetDatabaseEngine> VALUE_MAP;
    private final String value;

    private TargetDatabaseEngine(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetDatabaseEngine fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetDatabaseEngine> knownValues() {
        EnumSet<TargetDatabaseEngine> knownValues = EnumSet.allOf(TargetDatabaseEngine.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TargetDatabaseEngine.class, TargetDatabaseEngine::toString);
    }
}

