/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateApplicationComponentConfigRequest extends MigrationHubStrategyRequest implements
        ToCopyableBuilder<UpdateApplicationComponentConfigRequest.Builder, UpdateApplicationComponentConfigRequest> {
    private static final SdkField<String> APP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appType").getter(getter(UpdateApplicationComponentConfigRequest::appTypeAsString))
            .setter(setter(Builder::appType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appType").build()).build();

    private static final SdkField<String> APPLICATION_COMPONENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationComponentId").getter(getter(UpdateApplicationComponentConfigRequest::applicationComponentId))
            .setter(setter(Builder::applicationComponentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationComponentId").build())
            .build();

    private static final SdkField<Boolean> CONFIGURE_ONLY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("configureOnly").getter(getter(UpdateApplicationComponentConfigRequest::configureOnly))
            .setter(setter(Builder::configureOnly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configureOnly").build()).build();

    private static final SdkField<String> INCLUSION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inclusionStatus").getter(getter(UpdateApplicationComponentConfigRequest::inclusionStatusAsString))
            .setter(setter(Builder::inclusionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inclusionStatus").build()).build();

    private static final SdkField<String> SECRETS_MANAGER_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("secretsManagerKey").getter(getter(UpdateApplicationComponentConfigRequest::secretsManagerKey))
            .setter(setter(Builder::secretsManagerKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretsManagerKey").build()).build();

    private static final SdkField<List<SourceCode>> SOURCE_CODE_LIST_FIELD = SdkField
            .<List<SourceCode>> builder(MarshallingType.LIST)
            .memberName("sourceCodeList")
            .getter(getter(UpdateApplicationComponentConfigRequest::sourceCodeList))
            .setter(setter(Builder::sourceCodeList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceCode> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceCode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<StrategyOption> STRATEGY_OPTION_FIELD = SdkField
            .<StrategyOption> builder(MarshallingType.SDK_POJO).memberName("strategyOption")
            .getter(getter(UpdateApplicationComponentConfigRequest::strategyOption)).setter(setter(Builder::strategyOption))
            .constructor(StrategyOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("strategyOption").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_TYPE_FIELD,
            APPLICATION_COMPONENT_ID_FIELD, CONFIGURE_ONLY_FIELD, INCLUSION_STATUS_FIELD, SECRETS_MANAGER_KEY_FIELD,
            SOURCE_CODE_LIST_FIELD, STRATEGY_OPTION_FIELD));

    private final String appType;

    private final String applicationComponentId;

    private final Boolean configureOnly;

    private final String inclusionStatus;

    private final String secretsManagerKey;

    private final List<SourceCode> sourceCodeList;

    private final StrategyOption strategyOption;

    private UpdateApplicationComponentConfigRequest(BuilderImpl builder) {
        super(builder);
        this.appType = builder.appType;
        this.applicationComponentId = builder.applicationComponentId;
        this.configureOnly = builder.configureOnly;
        this.inclusionStatus = builder.inclusionStatus;
        this.secretsManagerKey = builder.secretsManagerKey;
        this.sourceCodeList = builder.sourceCodeList;
        this.strategyOption = builder.strategyOption;
    }

    /**
     * <p>
     * The type of known component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appType} will
     * return {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appTypeAsString}.
     * </p>
     * 
     * @return The type of known component.
     * @see AppType
     */
    public final AppType appType() {
        return AppType.fromValue(appType);
    }

    /**
     * <p>
     * The type of known component.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #appType} will
     * return {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #appTypeAsString}.
     * </p>
     * 
     * @return The type of known component.
     * @see AppType
     */
    public final String appTypeAsString() {
        return appType;
    }

    /**
     * <p>
     * The ID of the application component. The ID is unique within an AWS account.
     * </p>
     * 
     * @return The ID of the application component. The ID is unique within an AWS account.
     */
    public final String applicationComponentId() {
        return applicationComponentId;
    }

    /**
     * <p>
     * Update the configuration request of an application component. If it is set to true, the source code and/or
     * database credentials are updated. If it is set to false, the source code and/or database credentials are updated
     * and an analysis is initiated.
     * </p>
     * 
     * @return Update the configuration request of an application component. If it is set to true, the source code
     *         and/or database credentials are updated. If it is set to false, the source code and/or database
     *         credentials are updated and an analysis is initiated.
     */
    public final Boolean configureOnly() {
        return configureOnly;
    }

    /**
     * <p>
     * Indicates whether the application component has been included for server recommendation or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inclusionStatus}
     * will return {@link InclusionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inclusionStatusAsString}.
     * </p>
     * 
     * @return Indicates whether the application component has been included for server recommendation or not.
     * @see InclusionStatus
     */
    public final InclusionStatus inclusionStatus() {
        return InclusionStatus.fromValue(inclusionStatus);
    }

    /**
     * <p>
     * Indicates whether the application component has been included for server recommendation or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inclusionStatus}
     * will return {@link InclusionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #inclusionStatusAsString}.
     * </p>
     * 
     * @return Indicates whether the application component has been included for server recommendation or not.
     * @see InclusionStatus
     */
    public final String inclusionStatusAsString() {
        return inclusionStatus;
    }

    /**
     * <p>
     * Database credentials.
     * </p>
     * 
     * @return Database credentials.
     */
    public final String secretsManagerKey() {
        return secretsManagerKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceCodeList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceCodeList() {
        return sourceCodeList != null && !(sourceCodeList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of source code configurations to update for the application component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceCodeList} method.
     * </p>
     * 
     * @return The list of source code configurations to update for the application component.
     */
    public final List<SourceCode> sourceCodeList() {
        return sourceCodeList;
    }

    /**
     * <p>
     * The preferred strategy options for the application component. Use values from the
     * <a>GetApplicationComponentStrategies</a> response.
     * </p>
     * 
     * @return The preferred strategy options for the application component. Use values from the
     *         <a>GetApplicationComponentStrategies</a> response.
     */
    public final StrategyOption strategyOption() {
        return strategyOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applicationComponentId());
        hashCode = 31 * hashCode + Objects.hashCode(configureOnly());
        hashCode = 31 * hashCode + Objects.hashCode(inclusionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceCodeList() ? sourceCodeList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(strategyOption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationComponentConfigRequest)) {
            return false;
        }
        UpdateApplicationComponentConfigRequest other = (UpdateApplicationComponentConfigRequest) obj;
        return Objects.equals(appTypeAsString(), other.appTypeAsString())
                && Objects.equals(applicationComponentId(), other.applicationComponentId())
                && Objects.equals(configureOnly(), other.configureOnly())
                && Objects.equals(inclusionStatusAsString(), other.inclusionStatusAsString())
                && Objects.equals(secretsManagerKey(), other.secretsManagerKey())
                && hasSourceCodeList() == other.hasSourceCodeList() && Objects.equals(sourceCodeList(), other.sourceCodeList())
                && Objects.equals(strategyOption(), other.strategyOption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateApplicationComponentConfigRequest").add("AppType", appTypeAsString())
                .add("ApplicationComponentId", applicationComponentId()).add("ConfigureOnly", configureOnly())
                .add("InclusionStatus", inclusionStatusAsString())
                .add("SecretsManagerKey", secretsManagerKey() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SourceCodeList", hasSourceCodeList() ? sourceCodeList() : null).add("StrategyOption", strategyOption())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "appType":
            return Optional.ofNullable(clazz.cast(appTypeAsString()));
        case "applicationComponentId":
            return Optional.ofNullable(clazz.cast(applicationComponentId()));
        case "configureOnly":
            return Optional.ofNullable(clazz.cast(configureOnly()));
        case "inclusionStatus":
            return Optional.ofNullable(clazz.cast(inclusionStatusAsString()));
        case "secretsManagerKey":
            return Optional.ofNullable(clazz.cast(secretsManagerKey()));
        case "sourceCodeList":
            return Optional.ofNullable(clazz.cast(sourceCodeList()));
        case "strategyOption":
            return Optional.ofNullable(clazz.cast(strategyOption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateApplicationComponentConfigRequest, T> g) {
        return obj -> g.apply((UpdateApplicationComponentConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubStrategyRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateApplicationComponentConfigRequest> {
        /**
         * <p>
         * The type of known component.
         * </p>
         * 
         * @param appType
         *        The type of known component.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder appType(String appType);

        /**
         * <p>
         * The type of known component.
         * </p>
         * 
         * @param appType
         *        The type of known component.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder appType(AppType appType);

        /**
         * <p>
         * The ID of the application component. The ID is unique within an AWS account.
         * </p>
         * 
         * @param applicationComponentId
         *        The ID of the application component. The ID is unique within an AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationComponentId(String applicationComponentId);

        /**
         * <p>
         * Update the configuration request of an application component. If it is set to true, the source code and/or
         * database credentials are updated. If it is set to false, the source code and/or database credentials are
         * updated and an analysis is initiated.
         * </p>
         * 
         * @param configureOnly
         *        Update the configuration request of an application component. If it is set to true, the source code
         *        and/or database credentials are updated. If it is set to false, the source code and/or database
         *        credentials are updated and an analysis is initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configureOnly(Boolean configureOnly);

        /**
         * <p>
         * Indicates whether the application component has been included for server recommendation or not.
         * </p>
         * 
         * @param inclusionStatus
         *        Indicates whether the application component has been included for server recommendation or not.
         * @see InclusionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InclusionStatus
         */
        Builder inclusionStatus(String inclusionStatus);

        /**
         * <p>
         * Indicates whether the application component has been included for server recommendation or not.
         * </p>
         * 
         * @param inclusionStatus
         *        Indicates whether the application component has been included for server recommendation or not.
         * @see InclusionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InclusionStatus
         */
        Builder inclusionStatus(InclusionStatus inclusionStatus);

        /**
         * <p>
         * Database credentials.
         * </p>
         * 
         * @param secretsManagerKey
         *        Database credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerKey(String secretsManagerKey);

        /**
         * <p>
         * The list of source code configurations to update for the application component.
         * </p>
         * 
         * @param sourceCodeList
         *        The list of source code configurations to update for the application component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeList(Collection<SourceCode> sourceCodeList);

        /**
         * <p>
         * The list of source code configurations to update for the application component.
         * </p>
         * 
         * @param sourceCodeList
         *        The list of source code configurations to update for the application component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeList(SourceCode... sourceCodeList);

        /**
         * <p>
         * The list of source code configurations to update for the application component.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.SourceCode.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.SourceCode#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.migrationhubstrategy.model.SourceCode.Builder#build()} is called
         * immediately and its result is passed to {@link #sourceCodeList(List<SourceCode>)}.
         * 
         * @param sourceCodeList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.migrationhubstrategy.model.SourceCode.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceCodeList(java.util.Collection<SourceCode>)
         */
        Builder sourceCodeList(Consumer<SourceCode.Builder>... sourceCodeList);

        /**
         * <p>
         * The preferred strategy options for the application component. Use values from the
         * <a>GetApplicationComponentStrategies</a> response.
         * </p>
         * 
         * @param strategyOption
         *        The preferred strategy options for the application component. Use values from the
         *        <a>GetApplicationComponentStrategies</a> response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder strategyOption(StrategyOption strategyOption);

        /**
         * <p>
         * The preferred strategy options for the application component. Use values from the
         * <a>GetApplicationComponentStrategies</a> response.
         * </p>
         * This is a convenience method that creates an instance of the {@link StrategyOption.Builder} avoiding the need
         * to create one manually via {@link StrategyOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StrategyOption.Builder#build()} is called immediately and its
         * result is passed to {@link #strategyOption(StrategyOption)}.
         * 
         * @param strategyOption
         *        a consumer that will call methods on {@link StrategyOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #strategyOption(StrategyOption)
         */
        default Builder strategyOption(Consumer<StrategyOption.Builder> strategyOption) {
            return strategyOption(StrategyOption.builder().applyMutation(strategyOption).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MigrationHubStrategyRequest.BuilderImpl implements Builder {
        private String appType;

        private String applicationComponentId;

        private Boolean configureOnly;

        private String inclusionStatus;

        private String secretsManagerKey;

        private List<SourceCode> sourceCodeList = DefaultSdkAutoConstructList.getInstance();

        private StrategyOption strategyOption;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationComponentConfigRequest model) {
            super(model);
            appType(model.appType);
            applicationComponentId(model.applicationComponentId);
            configureOnly(model.configureOnly);
            inclusionStatus(model.inclusionStatus);
            secretsManagerKey(model.secretsManagerKey);
            sourceCodeList(model.sourceCodeList);
            strategyOption(model.strategyOption);
        }

        public final String getAppType() {
            return appType;
        }

        public final void setAppType(String appType) {
            this.appType = appType;
        }

        @Override
        public final Builder appType(String appType) {
            this.appType = appType;
            return this;
        }

        @Override
        public final Builder appType(AppType appType) {
            this.appType(appType == null ? null : appType.toString());
            return this;
        }

        public final String getApplicationComponentId() {
            return applicationComponentId;
        }

        public final void setApplicationComponentId(String applicationComponentId) {
            this.applicationComponentId = applicationComponentId;
        }

        @Override
        public final Builder applicationComponentId(String applicationComponentId) {
            this.applicationComponentId = applicationComponentId;
            return this;
        }

        public final Boolean getConfigureOnly() {
            return configureOnly;
        }

        public final void setConfigureOnly(Boolean configureOnly) {
            this.configureOnly = configureOnly;
        }

        @Override
        public final Builder configureOnly(Boolean configureOnly) {
            this.configureOnly = configureOnly;
            return this;
        }

        public final String getInclusionStatus() {
            return inclusionStatus;
        }

        public final void setInclusionStatus(String inclusionStatus) {
            this.inclusionStatus = inclusionStatus;
        }

        @Override
        public final Builder inclusionStatus(String inclusionStatus) {
            this.inclusionStatus = inclusionStatus;
            return this;
        }

        @Override
        public final Builder inclusionStatus(InclusionStatus inclusionStatus) {
            this.inclusionStatus(inclusionStatus == null ? null : inclusionStatus.toString());
            return this;
        }

        public final String getSecretsManagerKey() {
            return secretsManagerKey;
        }

        public final void setSecretsManagerKey(String secretsManagerKey) {
            this.secretsManagerKey = secretsManagerKey;
        }

        @Override
        public final Builder secretsManagerKey(String secretsManagerKey) {
            this.secretsManagerKey = secretsManagerKey;
            return this;
        }

        public final List<SourceCode.Builder> getSourceCodeList() {
            List<SourceCode.Builder> result = SourceCodeListCopier.copyToBuilder(this.sourceCodeList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSourceCodeList(Collection<SourceCode.BuilderImpl> sourceCodeList) {
            this.sourceCodeList = SourceCodeListCopier.copyFromBuilder(sourceCodeList);
        }

        @Override
        public final Builder sourceCodeList(Collection<SourceCode> sourceCodeList) {
            this.sourceCodeList = SourceCodeListCopier.copy(sourceCodeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceCodeList(SourceCode... sourceCodeList) {
            sourceCodeList(Arrays.asList(sourceCodeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceCodeList(Consumer<SourceCode.Builder>... sourceCodeList) {
            sourceCodeList(Stream.of(sourceCodeList).map(c -> SourceCode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final StrategyOption.Builder getStrategyOption() {
            return strategyOption != null ? strategyOption.toBuilder() : null;
        }

        public final void setStrategyOption(StrategyOption.BuilderImpl strategyOption) {
            this.strategyOption = strategyOption != null ? strategyOption.build() : null;
        }

        @Override
        public final Builder strategyOption(StrategyOption strategyOption) {
            this.strategyOption = strategyOption;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationComponentConfigRequest build() {
            return new UpdateApplicationComponentConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
