/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum TargetDestination {
    NONE_SPECIFIED("None specified"),

    AWS_ELASTIC_BEAN_STALK("AWS Elastic BeanStalk"),

    AWS_FARGATE("AWS Fargate"),

    AMAZON_ELASTIC_CLOUD_COMPUTE_EC2("Amazon Elastic Cloud Compute (EC2)"),

    AMAZON_ELASTIC_CONTAINER_SERVICE_ECS("Amazon Elastic Container Service (ECS)"),

    AMAZON_ELASTIC_KUBERNETES_SERVICE_EKS("Amazon Elastic Kubernetes Service (EKS)"),

    AURORA_MY_SQL("Aurora MySQL"),

    AURORA_POSTGRE_SQL("Aurora PostgreSQL"),

    AMAZON_RELATIONAL_DATABASE_SERVICE_ON_MY_SQL("Amazon Relational Database Service on MySQL"),

    AMAZON_RELATIONAL_DATABASE_SERVICE_ON_POSTGRE_SQL("Amazon Relational Database Service on PostgreSQL"),

    AMAZON_DOCUMENT_DB("Amazon DocumentDB"),

    AMAZON_DYNAMO_DB("Amazon DynamoDB"),

    AMAZON_RELATIONAL_DATABASE_SERVICE("Amazon Relational Database Service"),

    BABELFISH_FOR_AURORA_POSTGRE_SQL("Babelfish for Aurora PostgreSQL"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetDestination> VALUE_MAP = EnumUtils.uniqueIndex(TargetDestination.class,
            TargetDestination::toString);

    private final String value;

    private TargetDestination(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return TargetDestination corresponding to the value
     */
    public static TargetDestination fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link TargetDestination}s
     */
    public static Set<TargetDestination> knownValues() {
        Set<TargetDestination> knownValues = EnumSet.allOf(TargetDestination.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
