/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubstrategy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Detailed information of the pipeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PipelineInfo implements SdkPojo, Serializable, ToCopyableBuilder<PipelineInfo.Builder, PipelineInfo> {
    private static final SdkField<String> PIPELINE_CONFIGURATION_TIME_STAMP_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("pipelineConfigurationTimeStamp")
            .getter(getter(PipelineInfo::pipelineConfigurationTimeStamp))
            .setter(setter(Builder::pipelineConfigurationTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineConfigurationTimeStamp")
                    .build()).build();

    private static final SdkField<String> PIPELINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pipelineType").getter(getter(PipelineInfo::pipelineTypeAsString)).setter(setter(Builder::pipelineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PIPELINE_CONFIGURATION_TIME_STAMP_FIELD, PIPELINE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String pipelineConfigurationTimeStamp;

    private final String pipelineType;

    private PipelineInfo(BuilderImpl builder) {
        this.pipelineConfigurationTimeStamp = builder.pipelineConfigurationTimeStamp;
        this.pipelineType = builder.pipelineType;
    }

    /**
     * <p>
     * The time when the pipeline info was configured.
     * </p>
     * 
     * @return The time when the pipeline info was configured.
     */
    public final String pipelineConfigurationTimeStamp() {
        return pipelineConfigurationTimeStamp;
    }

    /**
     * <p>
     * The type of pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pipelineType} will
     * return {@link PipelineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pipelineTypeAsString}.
     * </p>
     * 
     * @return The type of pipeline.
     * @see PipelineType
     */
    public final PipelineType pipelineType() {
        return PipelineType.fromValue(pipelineType);
    }

    /**
     * <p>
     * The type of pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pipelineType} will
     * return {@link PipelineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pipelineTypeAsString}.
     * </p>
     * 
     * @return The type of pipeline.
     * @see PipelineType
     */
    public final String pipelineTypeAsString() {
        return pipelineType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pipelineConfigurationTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipelineInfo)) {
            return false;
        }
        PipelineInfo other = (PipelineInfo) obj;
        return Objects.equals(pipelineConfigurationTimeStamp(), other.pipelineConfigurationTimeStamp())
                && Objects.equals(pipelineTypeAsString(), other.pipelineTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PipelineInfo").add("PipelineConfigurationTimeStamp", pipelineConfigurationTimeStamp())
                .add("PipelineType", pipelineTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pipelineConfigurationTimeStamp":
            return Optional.ofNullable(clazz.cast(pipelineConfigurationTimeStamp()));
        case "pipelineType":
            return Optional.ofNullable(clazz.cast(pipelineTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PipelineInfo, T> g) {
        return obj -> g.apply((PipelineInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PipelineInfo> {
        /**
         * <p>
         * The time when the pipeline info was configured.
         * </p>
         * 
         * @param pipelineConfigurationTimeStamp
         *        The time when the pipeline info was configured.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineConfigurationTimeStamp(String pipelineConfigurationTimeStamp);

        /**
         * <p>
         * The type of pipeline.
         * </p>
         * 
         * @param pipelineType
         *        The type of pipeline.
         * @see PipelineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineType
         */
        Builder pipelineType(String pipelineType);

        /**
         * <p>
         * The type of pipeline.
         * </p>
         * 
         * @param pipelineType
         *        The type of pipeline.
         * @see PipelineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PipelineType
         */
        Builder pipelineType(PipelineType pipelineType);
    }

    static final class BuilderImpl implements Builder {
        private String pipelineConfigurationTimeStamp;

        private String pipelineType;

        private BuilderImpl() {
        }

        private BuilderImpl(PipelineInfo model) {
            pipelineConfigurationTimeStamp(model.pipelineConfigurationTimeStamp);
            pipelineType(model.pipelineType);
        }

        public final String getPipelineConfigurationTimeStamp() {
            return pipelineConfigurationTimeStamp;
        }

        public final void setPipelineConfigurationTimeStamp(String pipelineConfigurationTimeStamp) {
            this.pipelineConfigurationTimeStamp = pipelineConfigurationTimeStamp;
        }

        @Override
        public final Builder pipelineConfigurationTimeStamp(String pipelineConfigurationTimeStamp) {
            this.pipelineConfigurationTimeStamp = pipelineConfigurationTimeStamp;
            return this;
        }

        public final String getPipelineType() {
            return pipelineType;
        }

        public final void setPipelineType(String pipelineType) {
            this.pipelineType = pipelineType;
        }

        @Override
        public final Builder pipelineType(String pipelineType) {
            this.pipelineType = pipelineType;
            return this;
        }

        @Override
        public final Builder pipelineType(PipelineType pipelineType) {
            this.pipelineType(pipelineType == null ? null : pipelineType.toString());
            return this;
        }

        @Override
        public PipelineInfo build() {
            return new PipelineInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
