/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhubrefactorspaces.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ErrorResourceType {
    ENVIRONMENT("ENVIRONMENT"),

    APPLICATION("APPLICATION"),

    ROUTE("ROUTE"),

    SERVICE("SERVICE"),

    TRANSIT_GATEWAY("TRANSIT_GATEWAY"),

    TRANSIT_GATEWAY_ATTACHMENT("TRANSIT_GATEWAY_ATTACHMENT"),

    API_GATEWAY("API_GATEWAY"),

    NLB("NLB"),

    TARGET_GROUP("TARGET_GROUP"),

    LOAD_BALANCER_LISTENER("LOAD_BALANCER_LISTENER"),

    VPC_LINK("VPC_LINK"),

    LAMBDA("LAMBDA"),

    VPC("VPC"),

    SUBNET("SUBNET"),

    ROUTE_TABLE("ROUTE_TABLE"),

    SECURITY_GROUP("SECURITY_GROUP"),

    VPC_ENDPOINT_SERVICE_CONFIGURATION("VPC_ENDPOINT_SERVICE_CONFIGURATION"),

    RESOURCE_SHARE("RESOURCE_SHARE"),

    IAM_ROLE("IAM_ROLE"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ErrorResourceType> VALUE_MAP = EnumUtils.uniqueIndex(ErrorResourceType.class,
            ErrorResourceType::toString);

    private final String value;

    private ErrorResourceType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ErrorResourceType corresponding to the value
     */
    public static ErrorResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ErrorResourceType}s
     */
    public static Set<ErrorResourceType> knownValues() {
        Set<ErrorResourceType> knownValues = EnumSet.allOf(ErrorResourceType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
